<?php
/**
 * The Download Custom Post Type
 */

if ( !defined( 'ABSPATH' ) )
	die( '-1' );

if ( ! class_exists( 'Studiare_Studi_Header' ) ) {

	class Studiare_Studi_Header {

		public static $instance;

		// Setup a single instance using the singleton pattern
		public static function init() {

			if ( is_null( self::$instance ) ) {
				self::$instance = new Studiare_Studi_Header();
			}
			return self::$instance;

		}

		function __construct() {

			add_action( 'init', array($this, 'register_post_type' ), 5 );
			/*add_action( 'cmb2_admin_init', array($this,'register_meta_boxes' ));*/

			if( is_admin() ) {

				add_filter( 'manage_edit-teacher_columns' , array( $this,'add_studi_header_columns' ) );
				add_action( 'manage_teacher_posts_custom_column' , array( $this,'set_teacher_columns_content' ), 10, 2 );

			}
		}

		function register_post_type() {

			$options = get_option( 'studiare-core-options' );

			if ( post_type_exists( 'studi_header' ) ) {
				return;
			}

			$labels = array(
				'name'                => _x( 'سربرگ استادیار', 'Post Type General Name', 'studiare-core' ),
				'singular_name'       => _x( 'سربرگ', 'Post Type Singular Name', 'studiare-core' ),
				'menu_name'           => __( 'سربرگ استادیار', 'studiare-core' ),
				'parent_item_colon'   => __( 'سربرگ والد:', 'studiare-core' ),
				'all_items'           => __( 'همه سربرگ ها', 'studiare-core' ),
				'view_item'           => __( 'مشاهده', 'studiare-core' ),
				'add_new_item'        => __( 'افزودن جدید', 'studiare-core' ),
				'add_new'             => __( 'افزودن جدید', 'studiare-core' ),
				'edit_item'           => __( 'ویرایش سربرگ', 'studiare-core' ),
				'update_item'         => __( 'بروزرسانی سربرگ', 'studiare-core' ),
				'search_items'        => __( 'جستجوی سربرگ', 'studiare-core' ),
				'not_found'           => __( 'یافت نشد', 'studiare-core' ),
				'not_found_in_trash'  => __( 'در سطل زباله یافت نشد', 'studiare-core' ),
			);

			$rewrite = array(
				'slug'                => 'studi_header', // $options['studi_header-slug'],
				'with_front'          => false,
			);

			$args = array(
				'label'               => __( 'header', 'studiare-core' ),
				'description'         => __( 'Header Post Type', 'studiare-core' ),
				'labels'              => $labels,
				// 'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
				'supports'            => array( 'title', 'editor' ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
            'show_in_menu'       => 'studiare_panel',
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'menu_position'       => 21,
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'query_var'           => true,
				'rewrite'             => $rewrite,
				'menu_icon'           => 'dashicons-tagcloud',
				'capability_type'     => 'post',
			);

			register_post_type( 'studi_header', $args );

		}

		function register_meta_boxes() {

			$prefix = '_studiare_';

			$studi_header_metaboxes = new_cmb2_box( array(
				'id'           => 'studi_header_metabox',
				'title'        => esc_html__( 'اطلاعات سربرگ', 'studiare' ),
				'object_types' => array( 'studi_header' ),
				'context'      => 'normal',
				'priority'     => 'high',
				'show_names'   => true,
			) );

			

			$studi_header_metaboxes->add_field( array(
				'name' => esc_html__( 'لینک فایل', 'studiare' ),
				'id' => 'file_url',
				'type' => 'file',
			) );

			
			
		}

		function add_studi_header_columns( $cols ) {

			$cols = array(
				'cb'        =>   '<input type="checkbox" />',
				'title'     => __( 'عنوان', 'studiare-core' ),
				'thumbnail' => __( 'Thumbnail', 'studiare-core')
			);

			return $cols;

		}

		function set_teacher_columns_content( $column, $post_id ) {

			$width = (int) 35;
			$height = (int) 35;

			switch( $column ) {

				case 'thumbnail' :
					$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
					$attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );

					if ( $thumbnail_id ) {
						$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
					} elseif ( $attachments ) {
						foreach ( $attachments as $attachment_id => $attachment ) {
							$thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
						}
					}

					if ( isset( $thumb ) && $thumb ) {
						echo wp_kses_post( $thumb );
					} else {
						echo __('None', 'educa-addons');
					}

					break;

			}

		}

	}

	Studiare_Studi_Header::init();
}
