// ajax-search.js

//https://wordpress.stackexchange.com/questions/401682/select2-ajax-and-wp-query-returns-all-and-does-not-filter
//https://select2.org/data-sources/ajax
jQuery(document).ready(function($) {
    
    // Initialize select2 on the specific select element
    $('#private_notif_selector_0_specific_users').select2({
         multiple: true,
        ajax: {
            url: ajaxurl,
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    action: 'sc_specific_users_search', // AJAX action
                    q: params.term
                };
            },
            processResults: function(data) {
                var options = [];
                // Add "None" option to the list
                options.push({ id: 'none', text: 'None' });
                
                if (data) {
                    // Loop through data and create options
                    jQuery.each(data, function(index, text) {
                        options.push({ id: text[0], text: text[1] });
                    });
                } else {
                    // No results found, add a message perhaps
                    options.push({ id: '', text: 'No results found' });
                }
                return {
                    results: options
                };
            },
            cache: true
        },
        minimumInputLength: 1,
    });
    
    
    // Initialize select2 on the specific select element
    $('#private_notif_selector_0_product_buyers').select2({
         multiple: true,
        ajax: {
            url: ajaxurl,
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    action: 'sc_get_product_list_search', // AJAX action
                    q: params.term
                };
            },
            processResults: function(data) {
                var options = [];
                // Add "None" option to the list
                options.push({ id: 'none', text: 'None' });
                
                if (data) {
                    // Loop through data and create options
                    jQuery.each(data, function(index, text) {
                        options.push({ id: text[0], text: text[1] });
                    });
                } else {
                    // No results found, add a message perhaps
                    options.push({ id: '', text: 'No results found' });
                }
                return {
                    results: options
                };
            },
            cache: true
        },
        minimumInputLength: 1,
    });
    
});