// ajax-search.js
/**
 * jQuery(document).ready(function($) {
    $('#lesson_data_0_sc_download_file').on('input', function() {
        var searchQuery = $(this).val();

        $.ajax({
            url: sc_ajax.ajaxurl,
            type: 'POST',
            data: {
                action: 'sc_download_search',
                search_query: searchQuery
            },
            success: function(response) {
                // Update UI with search results
                console.log(response);
            }
        });
    });
});
**/
//https://wordpress.stackexchange.com/questions/401682/select2-ajax-and-wp-query-returns-all-and-does-not-filter
//https://select2.org/data-sources/ajax
jQuery(document).ready(function($) {
    // Initialize select2 on the specific select element
    $('#lesson_data_0_sc_download_file').select2({
        ajax: {
            url: ajaxurl,
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    action: 'sc_download_search', // AJAX action
                    q: params.term
                };
            },
            processResults: function(data) {
                var options = [];
                // Add "None" option to the list
                options.push({ id: 'none', text: 'None' });
                
                if (data) {
                    // Loop through data and create options
                    jQuery.each(data, function(index, text) {
                        options.push({ id: text[0], text: text[1] });
                    });
                } else {
                    // No results found, add a message perhaps
                    options.push({ id: '', text: 'No results found' });
                }
                return {
                    results: options
                };
            },
            cache: true
        },
        minimumInputLength: 1,
    });
});