<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( !class_exists( 'Studiare_Chat_File' ) ) {
    class Studiare_Chat_File { 

        public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;
            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                
                $instance = new Studiare_Chat_File();
  
            }
            // Always return the instance
            return $instance;
            // The last metroid is in captivity. The galaxy is at peace.
        }
        
        
        public function __construct() {

           add_action('wp_ajax_stc_load_form_media', array($this , 'stc_load_form_media'));
           
           add_action('wp_ajax_stc_upload_media', array($this , 'stc_upload_media'));
           
           

    	}

        
        public function stc_load_form_media() { 
            
          $defaults  = array();  
          
          
          
          $args = wp_parse_args( $_POST , $defaults );

          extract( $args );
        
          
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 

          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
          ob_start(); 
          $this->stc_form_media_html();
          $result = ob_get_clean();   
          wp_send_json_success(compact('result'));
   
            
        }
        
        public function stc_form_media_html() { 
            
            $user = get_current_user_id();
            
            ?>
            
             <div class="stc-media-manager">
                <link href="https://releases.transloadit.com/uppy/v4.0.5/uppy.min.css" rel="stylesheet" />
                <div class="media-tab-content" id="stcModalOpener"></div>
                <div class="media-tab-content" id="uppyModalOpener"></div>
            
                <script type="module">
                    import {
                        Uppy,
                        Dashboard,
                        Webcam,
                        XHRUpload
                    } from 'https://releases.transloadit.com/uppy/v4.0.5/uppy.min.mjs';
                (function( $ ) {
                	'use strict';
                    $(document).ready(function() {
                        let totalBytes = 0;
                        let uploadedBytes = 0;
                        let lastProgress = {};
                        var $form = $('#form-create-messages');
                
                
                        $('#my-upload-tab').on('click', function(e) {
                            e.preventDefault();
                            $('.media-tab-content').hide();
                            $('#stcModalOpener').show();
                            loadUserUploadedMedia();
                        });
                
                        const uppy = new Uppy({ 
                                debug: true, 
                                autoProceed: false,
                                restrictions: {
                                    maxFileSize: parseInt(stc_chat.media_size) * 1024 * 1024, 
                                    allowedFileTypes: ['image/*', '.jpg', '.jpeg', '.png', '.gif' ,'.mp4' , '.mp3' , '.zip' , '.xlsx' , '.docx' , '.csv' , '.txt'] 
                                },
                                locale: {
                                    strings: {
                                    //	youCanOnlyUploadX: {
                                		//	0: 'check %{smart_count} file',
                                		//	1: 'check %{smart_count} files',
                                	//	},
                                        //youCanOnlyUploadFileTypes: 'check: %{types}',
                                    }  
                                } 
                             })
                            .use(Dashboard, { 
                                inline: true, 
                                target: $form.find('#uppyModalOpener')[0],
                                locale: {
                                    strings: {
                                       poweredBy: '', 
                                    }  
                                } 
                             })
                            .use(Webcam, { target: Dashboard })
                            .use(XHRUpload, {
                                endpoint: '/wp-admin/admin-ajax.php?action=stc_upload_media',
                                fieldName: 'file',
                                formData: true,
                                headers: {
                                    'X-WP-Nonce': stc_script.nonce
                                },
                                async onBeforeRequest(xhr) {
                                    $('#stc-file-container').removeClass('open');
                                },
                                async getResponseData(xhr) {
                                    if (xhr.status === 200) {
                                        const response = JSON.parse(xhr.response);
                                        if (response.success) {
                                            // Handle success response if needed
                                        } else {
                                            show_notification(response.data[0].message, 'error');
                                        }
                                    }
                                }
                            }).on('file-added', (file) => {
                                totalBytes += file.data.size;
                                lastProgress[file.id] = 0; // Initialize last progress for the file
                            }).on('upload-progress', (file, progress) => {
                                const increment = progress.bytesUploaded - lastProgress[file.id];
                                uploadedBytes += increment;
                                lastProgress[file.id] = progress.bytesUploaded;
                
                                const $progressBarContainer = $('#send-file');
                                let $progressBarFill = $('#progress-bar-fill');
                
                                if ($progressBarFill.length === 0) {
                                    $progressBarFill = $('<div>', { id: 'progress-bar-fill' });
                                    $progressBarContainer.append($progressBarFill);
                                    $progressBarContainer.addClass('progress');
                                }
                
                                const progress_end = totalBytes > 0 ? (uploadedBytes / totalBytes) * 100 : 0;
                                $progressBarFill.html(Math.round(progress_end) + "%");
                                $progressBarFill.css('width', progress_end + '%');
                
                                if (progress_end >= 100) {
                                    setTimeout(() => {
                                        $progressBarFill.remove();
                                        $progressBarContainer.removeClass('progress');
                                    }, 500);
                                }
                            }).on('upload-success', (file, res, uploadURL) => {
                                // Handle successful upload if needed
                                console.log(res);
                            }).on('complete', (result) => {
                                console.log(result);
                
                                  const attachmentIds = result.successful.map(file => {
                                    if (file.response.body.success) {
                                        return file.response.body.data;
                                    }
                                }).filter(id => id); 
                                
                              
                                $form.append('<input id="media-input" type="hidden" name="message_media"></input>');
                                $form.append('<button id="submit-media" style="display:none;" type="submit"></button>');
                                $form.find('#media-input').val(attachmentIds.join(', '));
                                $form.find('#submit-media').click();
                           
                                totalBytes = 0;
                                uploadedBytes = 0;
                                lastProgress = {};
                
                                $('#stc-file-container').removeClass('open');
                                uppy.cancelAll();
                                
                                $form.find('#submit-media').remove();
                                $form.find('#media-input').remove();
                            }).on('cancel-all', () => {
                                // Reset values when upload is cancelled
                                totalBytes = 0;
                                uploadedBytes = 0;
                                lastProgress = {};
                            });
                            });
                         })( jQuery );          
                  </script>
   
             </div>
            
            <?php
            
        }
        
        function stc_upload_media() {
   
    $user_id = get_current_user_id();

    $errors = new WP_Error(); 
    if (!is_user_logged_in()) {
      if ( ! $secure ) {
    		$errors->add(
                   'secure_miss',
                   esc_html('User not logged in.','studiare-core')
            );
            wp_send_json_error( $errors );
      }
    }

    if ( ! function_exists('wp_handle_upload') ) {
        require_once( ABSPATH . 'wp-admin/includes/file.php' );
    }

    $uploaded_files = $_FILES['file'];
    $upload_overrides = array( 'test_form' => false );
    $response = array();

       
        if ($uploaded_files['name']) {
            $file = array(
                'name'     => $uploaded_files['name'],
                'type'     => $uploaded_files['type'],
                'tmp_name' => $uploaded_files['tmp_name'],
                'error'    => $uploaded_files['error'],
                'size'     => $uploaded_files['size']
            );

            $movefile = wp_handle_upload( $file, $upload_overrides );

            if ( $movefile && ! isset( $movefile['error'] ) ) {
                $attachment = array(
                    'guid'           => $movefile['url'],
                    'post_mime_type' => $movefile['type'],
                    'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $movefile['file'] ) ),
                    'post_content'   => '',
                    'post_status'    => 'inherit',
                    'post_author'    => $user_id 
                );

                $attach_id = wp_insert_attachment( $attachment, $movefile['file'] );

                require_once( ABSPATH . 'wp-admin/includes/image.php' );
                $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                wp_update_attachment_metadata( $attach_id, $attach_data );
 
                $response = $attach_id;
            } else {
               
        		$errors->add(
                       'error_file',
                       $movefile['error']
                );
                wp_send_json_error( $errors );
                  
            }
        }
 
        wp_send_json_success($response);
    }

       
    }
}



function Studiare_Chat_File() {
    return Studiare_Chat_File::instance();
}

