(function($) {
    // Handle checkbox selection in WP_List_Table
    function initializeCheckboxSelection() {
        console.log('initializeCheckboxSelection called');
        console.log('Header checkboxes found:', $('.wp-list-table th.check-column input[type="checkbox"]').length);
        console.log('Row checkboxes found:', $('.wp-list-table tbody input[name="quiz_result[]"]').length);
        console.log('Form found:', $('#quiz-results-form').length);

        // Select/Deselect all checkboxes when header checkbox is clicked
        $(document).on('click', '.wp-list-table th.check-column input[type="checkbox"]', function(e) {
            console.log('Header checkbox clicked, checked:', $(this).prop('checked'));
            var isChecked = $(this).prop('checked');
            $('.wp-list-table tbody input[name="quiz_result[]"]').prop('checked', isChecked);
            $('.wp-list-table th.check-column input[type="checkbox"]').prop('checked', isChecked);
        });

        // Update header checkbox state based on individual checkbox selections
        $(document).on('click', '.wp-list-table tbody input[name="quiz_result[]"]', function(e) {
            console.log('Row checkbox clicked, ID:', $(this).val());
            var $checkboxes = $('.wp-list-table tbody input[name="quiz_result[]"]');
            var $headerCheckboxes = $('.wp-list-table th.check-column input[type="checkbox"]');
            var allChecked = $checkboxes.length === $checkboxes.filter(':checked').length;
            var someChecked = $checkboxes.filter(':checked').length > 0;

            $headerCheckboxes.prop('checked', allChecked);
            $headerCheckboxes.prop('indeterminate', someChecked && !allChecked);
        });

        // Log submit button click
        $(document).on('click', '#doaction', function() {
            console.log('Submit button clicked');
        });

        // Debug form submission
        $(document).on('submit', '#quiz-results-form', function(e) {
            var $form = $(this);
            var $selectedCheckboxes = $form.find('input[name="quiz_result[]"]:checked');
            var action = $form.find('#bulk-action-selector-top').val();
            var selectedIds = $selectedCheckboxes.map(function() { return $(this).val(); }).get();

            console.log('Form submitted, selected checkboxes:', $selectedCheckboxes.length, 'Action:', action, 'Selected IDs:', selectedIds);

            if (action !== '-1' && $selectedCheckboxes.length === 0) {
                e.preventDefault();
                alert('Please select at least one item to perform this action.');
            }
        });
    }

    // Initialize checkbox selection on page load
    $(document).ready(function() {
        console.log('Document ready, initializing checkbox selection');
        initializeCheckboxSelection();
    });

    // Re-initialize checkbox selection for dynamically loaded content
    $(document).on('DOMContentLoaded elementor/popup/show elementor/tabs/activate ajaxComplete', function() {
        console.log('Dynamic content loaded, re-initializing checkbox selection');
        initializeCheckboxSelection();
    });
})(jQuery);