<?php
/**
 * Studiare Quiz Installation
 * Handles database table creation for quiz results and attempts
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Create quiz results table
 */
function studiare_quiz_create_results_table() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'studiare_quiz_results';
    $charset_collate = $wpdb->get_charset_collate();

    // SQL to create the results table
    $sql = "CREATE TABLE $table_name (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        user_id BIGINT(20) UNSIGNED NOT NULL,
        quiz_id BIGINT(20) UNSIGNED NOT NULL,
        product_id BIGINT(20) UNSIGNED DEFAULT NULL, -- Added product_id column
        score FLOAT NOT NULL,
        timestamp DATETIME NOT NULL,
        details LONGTEXT,
        PRIMARY KEY (id),
        KEY user_id (user_id),
        KEY quiz_id (quiz_id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
}

/**
 * Create quiz attempts table
 */
function studiare_quiz_create_attempts_table() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'studiare_quiz_attempts';
    $charset_collate = $wpdb->get_charset_collate();

    // SQL to create the attempts table
    $sql = "CREATE TABLE $table_name (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        user_id BIGINT(20) UNSIGNED NOT NULL,
        quiz_id BIGINT(20) UNSIGNED NOT NULL,
        start_time DATETIME NOT NULL,
        timer_seconds INT NOT NULL,
        is_completed TINYINT(1) DEFAULT 0,
        PRIMARY KEY (id),
        INDEX idx_user_quiz (user_id, quiz_id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
}

/**
 * Check and create/update tables on plugin load
 */
function studiare_quiz_check_table() {
    global $wpdb;

    $db_version = '1.2'; // Updated version to reflect new column
    $current_version = get_option('studiare_quiz_db_version', '0');

    if (version_compare($current_version, $db_version, '<')) {
        // Create or update the results table
        studiare_quiz_create_results_table();

        // Create or update the attempts table
        studiare_quiz_create_attempts_table();

        // Add product_id column to results table if not exists
        $results_table = $wpdb->prefix . 'studiare_quiz_results';
        $column_exists = $wpdb->get_results("SHOW COLUMNS FROM $results_table LIKE 'product_id'");

        if (empty($column_exists)) {
            $wpdb->query("ALTER TABLE $results_table ADD product_id BIGINT(20) UNSIGNED DEFAULT NULL");
        }

        // Verify both tables exist
        $results_table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $results_table)) === $results_table;
        $attempts_table = $wpdb->prefix . 'studiare_quiz_attempts';
        $attempts_table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $attempts_table)) === $attempts_table;

        if ($results_table_exists && $attempts_table_exists) {
            update_option('studiare_quiz_db_version', $db_version, false);
        }
    }
}
add_action('plugins_loaded', 'studiare_quiz_check_table');