<?php
/**
 * Register Quiz custom post type and taxonomy
 */
function studiare_register_sc_quiz_post_type() {
    // Check if the quiz post type is enabled in settings (default is true)
    if (get_option('studiare_quiz_post_type_enabled', true)) {
        // Get custom labels from settings or use defaults
        $quiz_name = get_option('studiare_quiz_name', __('Quizzes', 'studiare-core'));
        $quiz_singular_name = get_option('studiare_quiz_singular_name', __('Quiz', 'studiare-core'));

        // Labels for the Quiz post type
        $labels = [
            'name'               => $quiz_name,
            'singular_name'      => $quiz_singular_name,
            'menu_name'          => $quiz_name,
            'name_admin_bar'     => $quiz_singular_name,
            'add_new'            => __('Add New', 'studiare-core'),
            'add_new_item'       => sprintf(__('Add New %s', 'studiare-core'), $quiz_singular_name),
            'new_item'           => sprintf(__('New %s', 'studiare-core'), $quiz_singular_name),
            'edit_item'          => sprintf(__('Edit %s', 'studiare-core'), $quiz_singular_name),
            'view_item'          => sprintf(__('View %s', 'studiare-core'), $quiz_singular_name),
            'all_items'          => sprintf(__('All %s', 'studiare-core'), $quiz_name),
            'search_items'       => sprintf(__('Search %s', 'studiare-core'), $quiz_name),
            'not_found'          => sprintf(__('No %s found.', 'studiare-core'), strtolower($quiz_name)),
            'not_found_in_trash' => sprintf(__('No %s found in Trash.', 'studiare-core'), strtolower($quiz_name)),
        ];

        // Get custom slug and has_archive from settings
        $quiz_slug = get_option('studiare_quiz_slug', 'quizzes');
        $quiz_slug = !empty($quiz_slug) ? sanitize_title($quiz_slug) : 'quizzes'; // Fallback to 'quizzes' if empty
        $has_archive = get_option('studiare_quiz_has_archive', '1') === '1';
        $is_public = get_option('studiare_quiz_public', '1') === '1'; // Get public setting

        // Arguments for the Quiz post type
        $args = [
            'labels'             => $labels,
            'public'             => $is_public, // Use public setting
            'has_archive'        => $has_archive && $is_public, // Disable archive if not public
            'menu_icon'          => 'dashicons-welcome-learn-more',
            'supports'           => ['title', 'thumbnail'],
            'rewrite'            => $is_public ? ['slug' => $quiz_slug] : false, // Disable rewrite if not public
            'show_in_rest'       => true, // Enables Gutenberg editor
            'taxonomies'         => ['quiz_category'], // Connect the taxonomy
            'show_ui'            => true, // Ensure admin interface is still accessible
            'show_in_menu'       => true, // Keep in admin menu
        ];

        // Register the post type
        register_post_type('sc-quiz', $args);

        // Get custom taxonomy labels from settings or use defaults
        $quiz_category_name = get_option('studiare_quiz_category_name', __('Quiz Categories', 'studiare-core'));
        $quiz_category_singular_name = get_option('studiare_quiz_category_singular_name', __('Quiz Category', 'studiare-core'));

        // Labels for the Quiz Category taxonomy
        $taxonomy_labels = [
            'name'              => $quiz_category_name,
            'singular_name'     => $quiz_category_singular_name,
            'search_items'      => sprintf(__('Search %s', 'studiare-core'), $quiz_category_name),
            'all_items'         => sprintf(__('All %s', 'studiare-core'), $quiz_category_name),
            'parent_item'       => sprintf(__('Parent %s', 'studiare-core'), $quiz_category_singular_name),
            'parent_item_colon' => sprintf(__('Parent %s:', 'studiare-core'), $quiz_category_singular_name),
            'edit_item'         => sprintf(__('Edit %s', 'studiare-core'), $quiz_category_singular_name),
            'update_item'       => sprintf(__('Update %s', 'studiare-core'), $quiz_category_singular_name),
            'add_new_item'      => sprintf(__('Add New %s', 'studiare-core'), $quiz_category_singular_name),
            'new_item_name'     => sprintf(__('New %s Name', 'studiare-core'), $quiz_category_singular_name),
            'menu_name'         => $quiz_category_name,
        ];

        // Get custom taxonomy slug from settings
        $quiz_category_slug = get_option('studiare_quiz_category_slug', 'quiz-category');
        $quiz_category_slug = !empty($quiz_category_slug) ? sanitize_title($quiz_category_slug) : 'quiz-category'; // Fallback to 'quiz-category' if empty

        // Arguments for the Quiz Category taxonomy
        $taxonomy_args = [
            'labels'            => $taxonomy_labels,
            'hierarchical'      => true, // Hierarchical taxonomy (like categories)
            'show_admin_column' => true,
            'show_in_rest'      => true, // Enable for block editor
            'rewrite'           => $is_public ? ['slug' => $quiz_category_slug] : false, // Disable rewrite if not public
            'public'            => $is_public, // Use public setting
            'show_ui'           => true, // Ensure admin interface is still accessible
            'show_in_menu'      => true, // Keep in admin menu
        ];

        // Register the taxonomy for the 'sc-quiz' post type
        register_taxonomy('quiz_category', 'sc-quiz', $taxonomy_args);
    }
}

add_action('init', 'studiare_register_sc_quiz_post_type');
?>