<?php
/**
 * Plugin Name: Studiare Quiz
 * Description: A powerful quiz builder for multiple-choice exams with negative marking, timing, and unlimited questions.
 * Plugin URI: https://suncode.ir
 * Version: 1.0
 * Author: SunCode
 * Author URI: https://suncode.ir
 * Text Domain: studiare-core
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Define plugin constants early in the script
define('STUDIARE_QUIZ_PATH', plugin_dir_path(__FILE__));
define('STUDIARE_QUIZ_URL', plugin_dir_url(__FILE__));
define('STUDIARE_QUIZ_FILE', __FILE__);

// Load install.php early for activation hook
require_once STUDIARE_QUIZ_PATH . 'includes/install.php';

// Register activation hook
register_activation_hook(STUDIARE_QUIZ_FILE, 'studiare_quiz_create_results_table');

// Load other plugin files
function studiare_load_plugin_files() {
    require_once STUDIARE_QUIZ_PATH . 'includes/post-types.php';
    require_once STUDIARE_QUIZ_PATH . 'includes/meta-boxes.php';
    require_once STUDIARE_QUIZ_PATH . 'includes/frontend-display.php';
    if (get_option('studiare_quiz_admin_results_enabled', true)) {
        require_once STUDIARE_QUIZ_PATH . 'includes/admin-results.php';
    }
    require_once STUDIARE_QUIZ_PATH . 'includes/settings.php';
}
add_action('plugins_loaded', 'studiare_load_plugin_files');