<?php

// Display phone number in user profile v13.2
function sc_add_phone_to_user_profile($user) {
    $phone = get_user_meta($user->ID, 'user_phone', true);
    ?>
    <h3><?php _e('Additional Info', 'studiare-core'); ?></h3>
    <table class="form-table">
        <tr>
            <th><label for="user_phone"><?php _e('Phone Number', 'studiare-core'); ?></label></th>
            <td><input type="text" name="user_phone" id="user_phone" value="<?php echo esc_attr($phone); ?>" class="regular-text" readonly></td>
        </tr>
    </table>
    <?php
}
add_action('show_user_profile', 'sc_add_phone_to_user_profile');
add_action('edit_user_profile', 'sc_add_phone_to_user_profile');

// For older sites, use the custom function
function studi_get_user_by_vali_number($validated_phone) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sc_otp_tbl';
    $otp_info = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE mobile_number = %s ORDER BY id DESC LIMIT 1", $validated_phone));
    return $otp_info ? $otp_info->user_id : false;
}