jQuery(document).ready(function($) {
    // Send OTP for Registration
    $('#send-otp').on('click', function(e) {
        e.preventDefault();
        var phoneNumber = $('#otp_reg_phone').val();
        var $button = $(this);

        $('#sc_otp_reg_message').html('<div class="sc_otp_spinner"></div>');
        $.ajax({
            url: otp_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'otp_send_verification_code',
                otp_reg_phone: phoneNumber,
                nonce: otp_ajax_object.nonce // The nonce from localized script v13.2
            },
            beforeSend: function() {
                $button.prop('disabled', true);
            },
            success: function(response) {
                $('#sc_otp_reg_message').empty();
                if (response.success) {
                    $('#otp-container').show();
                    $('#register').show();
                    if (typeof toastr !== 'undefined' && typeof toastr.success === 'function') {
                        toastr.success(response.data.message || 'کد تأیید ارسال شد.', 'موفقیت', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }

                    // Start 120-second countdown
                    var counter = 120;
                    var secondTitle = $button.data('countertxt');
                    var mTitle = $button.data('mtitle');
                    $button.addClass('sc_cmn_timer_on').text(counter + ' ' + secondTitle);
                    var interval = setInterval(function() {
                        counter--;
                        $button.text(counter + ' ' + secondTitle);
                        if (counter < 1) {
                            clearInterval(interval);
                            $button.prop('disabled', false).removeClass('sc_cmn_timer_on').text(mTitle);
                        }
                    }, 1000);
                } else {
                    if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                        toastr.error(response.data.message || 'خطا در ارسال کد تأیید.', 'خطا', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }
                    $button.prop('disabled', false);
                }
            },
            error: function() {
                $('#sc_otp_reg_message').empty();
                if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                    toastr.error('خطا در ارتباط با سرور.', 'خطا', {
                        positionClass: 'toast-top-left',
                        closeButton: true,
                        progressBar: true
                    });
                }
                $button.prop('disabled', false);
            }
        });
    });

    // OTP Registration Form Submission
    $('#otp-registration-form').on('submit', function(e) {
        e.preventDefault();
        var otp = $('#otp_reg').val();
        var phoneNumber = $('#otp_reg_phone').val();
        var $button = $('#register');

        $('#sc_otp_reg_message').html('<div class="sc_otp_spinner"></div>');
        $.ajax({
            url: otp_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'otp_validate_otp',
                otp_reg: otp,
                otp_reg_phone: phoneNumber
            },
            beforeSend: function() {
                $button.prop('disabled', true);
            },
            success: function(response) {
                $('#sc_otp_reg_message').empty();
                if (response.success && response.data.redirect_url) {
                    if (typeof toastr !== 'undefined' && typeof toastr.success === 'function') {
                        toastr.success(response.data.message || 'ثبت‌نام موفق بود!', 'موفقیت', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }
                    window.location.href = response.data.redirect_url;
                } else {
                    if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                        toastr.error(response.data.message || 'خطای ناشناخته.', 'خطا', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }
                    $button.prop('disabled', false);
                }
            },
            error: function() {
                $('#sc_otp_reg_message').empty();
                if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                    toastr.error('خطا در ارتباط با سرور.', 'خطا', {
                        positionClass: 'toast-top-left',
                        closeButton: true,
                        progressBar: true
                    });
                }
                $button.prop('disabled', false);
            }
        });
    });

    // Send OTP for Login
    $('#send-login-otp').on('click', function(e) {
        e.preventDefault();
        var phoneNumber = $('#otp_phone').val();
        var $button = $(this);

        $('#sc_otp_login_message').html('<div class="sc_otp_spinner"></div>');
        $.ajax({
            url: otp_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'otp_send_verification_code',
                otp_phone: phoneNumber,
                nonce: otp_ajax_object.nonce // The nonce from localized script v13.2
            },
            beforeSend: function() {
                $button.prop('disabled', true);
            },
            success: function(response) {
                $('#sc_otp_login_message').empty();
                if (response.success) {
                    $('#otp-login-container').show();
                    $('#login').show();
                    if (typeof toastr !== 'undefined' && typeof toastr.success === 'function') {
                        toastr.success(response.data.message || 'کد تأیید ارسال شد.', 'موفقیت', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }

                    // Start 120-second countdown
                    var counter = 120;
                    var secondTitle = $button.data('countertxt');
                    var mTitle = $button.data('mtitle');
                    $button.addClass('sc_cmn_timer_on').text(counter + ' ' + secondTitle);
                    var interval = setInterval(function() {
                        counter--;
                        $button.text(counter + ' ' + secondTitle);
                        if (counter < 1) {
                            clearInterval(interval);
                            $button.prop('disabled', false).removeClass('sc_cmn_timer_on').text(mTitle);
                        }
                    }, 1000);
                } else {
                    if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                        toastr.error(response.data.message || 'خطا در ارسال کد تأیید.', 'خطا', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }
                    $button.prop('disabled', false);
                }
            },
            error: function() {
                $('#sc_otp_login_message').empty();
                if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                    toastr.error('خطا در ارتباط با سرور.', 'خطا', {
                        positionClass: 'toast-top-left',
                        closeButton: true,
                        progressBar: true
                    });
                }
                $button.prop('disabled', false);
            }
        });
    });

    // OTP Login Form Submission
    $('#otp-login-form').on('submit', function(e) {
        e.preventDefault();
        var otp = $('#otp_back').val();
        var phoneNumber = $('#otp_phone').val();
        var $button = $('#login');

        $('#sc_otp_login_message').html('<div class="sc_otp_spinner"></div>');
        $.ajax({
            url: otp_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'otp_login_validate_otp',
                otp_back: otp,
                otp_phone: phoneNumber
            },
            beforeSend: function() {
                $button.prop('disabled', true);
            },
            success: function(response) {
                $('#sc_otp_login_message').empty();
                if (response.success && response.data.redirect_url) {
                    if (typeof toastr !== 'undefined' && typeof toastr.success === 'function') {
                        toastr.success(response.data.message || 'ورود موفق بود!', 'موفقیت', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }
                    window.location.href = response.data.redirect_url;
                } else {
                    if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                        toastr.error(response.data.message || 'خطای ناشناخته.', 'خطا', {
                            positionClass: 'toast-top-left',
                            closeButton: true,
                            progressBar: true
                        });
                    }
                    $button.prop('disabled', false);
                }
            },
            error: function() {
                $('#sc_otp_login_message').empty();
                if (typeof toastr !== 'undefined' && typeof toastr.error === 'function') {
                    toastr.error('خطا در ارتباط با سرور.', 'خطا', {
                        positionClass: 'toast-top-left',
                        closeButton: true,
                        progressBar: true
                    });
                }
                $button.prop('disabled', false);
            }
        });
    });
});