<?php
// Abstract base class for SMS providers
abstract class SC_SMSProvider {
    abstract public function send_otp($phone);
}

include_once 'providers_classess.php';


// Function to get SMS provider instance based on settings
function sc_get_sms_provider() {
    $otp_provider = class_exists('Redux') ? codebean_option('otp_provider') : 'mellipayamak';
    $api_address = class_exists('Redux') ? codebean_option('mellipayamak_api_address') : '';

    switch ($otp_provider) {
        case 'mellipayamak':
            return new MellipayamakProvider($api_address);
        case 'ippanel':
            return new IPPanelProvider($api_address);    
        case 'farazsms':
            return new FarazsmsProvider();    
        case 'smsir':
            return new SMSIRProvider();    
        // Add other providers here in the future
        default:
            return new MellipayamakProvider($api_address);
    }
}

// Updated function to call SMS provider
function sc_call_sms_provider_api($phone) {
    
    $provider = sc_get_sms_provider();
    $response = $provider->send_otp($phone);
    if($response){return $response;}
    // Return empty response if no provider is matched
    return json_encode(array('status' => 'error', 'message' => 'No SMS provider configured.'));
}