<?php
/**
 * edit mobile number in woocommerce edit page
 * author: Javad Pourshahabadi
 * suncode
 **/

add_action('woocommerce_edit_account_form', 'add_user_mobile_field',1);

function add_user_mobile_field() {
    // Get the current user ID
    $user_id = get_current_user_id();

    // Get the user mobile from your custom table
    global $wpdb;
    $table_name = $wpdb->prefix . 'sc_otp_tbl';
    $user_mobile = $wpdb->get_var($wpdb->prepare("SELECT mobile_number FROM $table_name WHERE user_id = %d", $user_id));
if($user_mobile){$user_mobile=$user_mobile;}else{$user_mobile="-";}
    ?>
    <p class="form-row form-row-wide">
        <label for="user_mobile"><?php echo __('Mobile Number', 'studiare-core'); ?></label>
        <input readonly type="text" class="input-text mb-30" name="user_mobile" id="user_mobile" value="<?php echo esc_attr($user_mobile); ?>" />
    </p>
    <?php
} 


//add_action('woocommerce_save_account_details', 'save_user_mobile_field');

function save_user_mobile_field($user_id) {
    global $wpdb;

    if (isset($_POST['user_mobile'])) {
        // Sanitize the mobile number input
        $mobile_number = sanitize_text_field($_POST['user_mobile']);
        
        // Validate phone before proceeding
        $validated_phone = sc_validate_phone_number($mobile_number);
        if (!$validated_phone) {
            // Add an error notice if the phone number is invalid
            wc_add_notice(__('Invalid phone number.', 'studiare-core'), 'error');
            return;
        }
        
        // Update or insert into your custom table
        $table_name = $wpdb->prefix . 'sc_otp_tbl';

        // Update the mobile number in your custom table
        $updated = $wpdb->update(
            $table_name,
            array('mobile_number' => $mobile_number),
            array('user_id' => $user_id)
        );

        // Optionally check if the update was successful
        if ($updated === false) {
            // Add an error notice if the update failed
            wc_add_notice(__('Failed to update mobile number.', 'studiare-core'), 'error');
        } else {
            // Optionally: Add a success notice
           // wc_add_notice(__('Mobile number updated successfully.', 'studiare-core'), 'success');
        }
    }
}

