<?php 
class SWSS_UserPage
{
	public function __construct()
	{
		add_action ( 'show_user_profile', array( &$this,'render_expiring_products_dates'), 99);
		add_action ( 'edit_user_profile', array( &$this,'render_expiring_products_dates'), 99 );
		
		//add_action ( 'edit_user_profile_update', array( &$this,'save_data')); //user/admin is viewing other profile
		//add_action ( 'personal_options_update', array( &$this,'save_data')); //user/admin is viewing other profile
		
		// ADDING CUSTOM FIELDS TO INDIVIDUAL USER SETTINGS PAGE AND TO USER LIST
		add_action( 'show_user_profile', array( &$this,'add_extra_user_fields'), 99 );
		add_action( 'edit_user_profile', array( &$this,'add_extra_user_fields'), 99 );
		add_action( 'personal_options_update', array( &$this,'save_extra_user_fields'), 99 );
		add_action( 'edit_user_profile_update', array( &$this,'save_extra_user_fields' ), 99);
		
	}
	
	/* suncode start */
	function add_extra_user_fields( $user )
{
	
	/* adding user signature to reply start suncode */
			$isActive = get_field('swss_active_user_signature_'.$user->ID,'option')? get_field('swss_active_user_signature_'.$user->ID,'option') : false ;
			
				
				$swss_user_id =$user->ID;
				$user_signature = get_field('swss_user_sign_text_'.$swss_user_id,'option')? get_field('swss_user_sign_text_'.$swss_user_id,'option') : "" ;
					
				
				
			

    ?>
        <table class="form-table">
            <tr class="user-swss_active_user_signature">
                <th><label for="swss_active_user_signature"><?php echo __('User Signature','sunticket'); ?></label></th>
                <td><input type="checkbox" name="swss_active_user_signature" id="swss_active_user_signature" value="true" class="regular-text ltr" <?php if($isActive==true){echo "checked";}?> /> <?php echo __('Enable','sunticket'); ?>
				<br><?php echo  __('If this field is enabled, the signature text will be added at the end of the support user response.','sunticket'); ?>
            </td>
            </tr>
            <tr class="user-swss_user_sign_text-wrap">
                <th><label for="swss_user_sign_text"><?php echo __('User Text Signature','sunticket'); ?></label>
				
				</th>
                <!--<td><textarea name="swss_user_sign_text" id="swss_user_sign_text" rows="5" cols="30"><?php echo $user_signature; // textarea_escaped ?></textarea> -->
                <td><?php  wp_editor( $user_signature, 'swss_user_sign_text', array( 'theme_advanced_buttons1' => 'bold, italic, ul, pH, pH_min', "media_buttons" => true, "textarea_rows" => 8, "tabindex" => 4 ) ); ?>
                </td>
            </tr>
        </table>
    <?php
}

// Saving Updated fields data

function save_extra_user_fields( $user_id )
{
	update_option('options_swss_active_user_signature_'.$user_id, $_POST['swss_active_user_signature']  ); 
	update_option('options_swss_user_sign_text_'.$user_id, $_POST['swss_user_sign_text'] ); 
    
}
	/* suncode start */
	
	public function render_expiring_products_dates( $user )
	{
		if(!is_admin())
			return;
		
		
		
		wp_enqueue_style('swss-profile-page', SWSS_PLUGIN_PATH. '/css/backend-user-profile-page.css' );
			
		global $swss_ticket_model, $swss_user_model;
		$ppt_data= $swss_user_model->get_pp_meta($user->ID);
		$tickets = $swss_ticket_model->get_tickets_managed_by_user($user->ID);
		echo '<h3>'.__( 'Assigned tickets', 'sunticket' ).'</h3>';
		echo '<table class="form-table">';
		echo '<tbody>';
		echo '<tr>';
			echo '<th><label class="swss_ticket_label">'.__( 'Tickets id(s)', 'sunticket' ).'</label></th>';
			echo '<td>';
			$counter_tmp = 0;
			foreach((array)$tickets as $ticket)
			{
				$ticket_id = $ticket['ticket_id'];
				if($counter_tmp++)
					echo ", ";
				echo '<span class="wcra_purchased_date_content"><a href="'.esc_url(get_edit_post_link($ticket_id)).'" target="_blank">'.$ticket_id.'</a></span>';
			
			} 
			echo '</td>';
		echo '</tr>';
		echo '</tbody>';
		echo '</table>';
		
		return;
		$counter = 1;
		echo '<h3>'.__( 'Pay per ticket', 'sunticket' ).'</h3>';
			echo '<table class="form-table">';
			echo '<tbody>';
		foreach($ppt_data as $tikect_data)
		{
			
			echo '<tr>';
				echo '<th><label class="swss_ticket_label">'.$counter++.". ".__( 'Product name', 'sunticket' ).'</label></th>';
				echo '<td>'.$tikect_data->value['product_name'].'</td>';
			echo '</tr>';
			echo '<tr>';
				echo '<th><label class="swss_ticket_label">'.__( 'Questions left', 'sunticket' ).'</label></th>';
				echo '<td><input type="number" min="0" required="required" name="swss_ppt[questions_number]['.$tikect_data->id.']" value="'.$tikect_data->value['questions_number'].'"></input></td>';
			echo '</tr>';
			//questions left?: No, left value is the questions_number
			echo '<tr>';
				echo '<th><label class="swss_ticket_label">'.__( 'Purchased on', 'sunticket' ).'</label></th>';
				$date = date($tikect_data->value['order_date']);            
				$date_timestamp = strtotime($date);
				$formatted_date = date(get_option('date_format')." ".get_option('time_format'), $date_timestamp); 
				echo '<td>'.$formatted_date.'</td>';
			echo '</tr>';
			echo '<tr class="swss_border_bottom">';
				echo '<th><label class="swss_ticket_label">'.__( 'Delete', 'sunticket' ).'</label></th>';
				echo '<td><input type="checkbox" name="swss_ppt[delete_meta_by_id]['.$tikect_data->id.']" value="true">'.__( 'To delete a Pay Per Ticket data, just check the checkbox and then it the "Update Profile" button you find at the bottom of the page', 'sunticket' ).'</input></td>';
			echo '</tr>';
		}
		echo '</tbody>';
		echo '</table>';
	}
	
	public function save_data($user_id = 0) //it is never 0
	{
		global $swss_user_model;
		if($user_id == 0 || !isset($_POST['swss_ppt']))
			return;
		
		/* Format: 
		array(2) {
		  ["questions_number"]=>
		  array(2) {
			[270512]=>
			string(1) "3"
			[270513]=>
			string(4) "2122"
		  }
		  ["delete_meta_by_id"]=>
		  array(1) {
			[270513]=>
			string(4) "true"
		  }
		}
		*/
		$to_delete = array();
		if(isset($_POST['swss_ppt']['delete_meta_by_id']))
			foreach((array)$_POST['swss_ppt']['delete_meta_by_id'] as $id_to_delete => $value)
				$to_delete[] = $id_to_delete;
				
		$swss_user_model->delete_ppt_meta_by_ids($user_id, $to_delete);
		
		$to_update = array();
		if(isset($_POST['swss_ppt']['questions_number']))
			foreach((array)$_POST['swss_ppt']['questions_number'] as $id_to_update => $value)
			{
				$to_update[] = array('id'=> $id_to_update, 'questions_number' => $value);
			}
				
		$swss_user_model->update_ppt_question_numbers_metas_by_ids($user_id, $to_update);	
	}
	
}
?>