<?php 
/* suncode
created-date: 2021-07-09
 */
class SWSS_ProductPageTab
{
	public function __construct()
	{
		
		add_action('woocommerce_product_tabs', array( &$this, 'ticket_product_tab' ), 999 );
	}
		
	public function ticket_product_tab( $tabs )
	{
		
		$tabs['swss_ticket_product_tab'] = array(
		'title' 	=> __( 'Support Ticket', 'sunticket' ),
		'priority' 	=> 50,
		'callback' 	=> array( &$this, 'render_ticket_product_tab' ),
		);

		return $tabs;
		
	}
	
	public function render_ticket_product_tab()
	{
		
		$html ="";
		// GET CURR USER
		$current_user = wp_get_current_user();
		if ( 0 == $current_user->ID ) {
			$html .= __('Please login to your account to add or view tickets ','sunticket');
		}else{
			
			wp_enqueue_style('swss-my-account', SWSS_PLUGIN_PATH.'/css/frontend-my-account.css');
			
			global $wp;
			
			$current_url = get_permalink( wc_get_page_id( 'myaccount' ) );
			$swss_alias = get_option("swss-user-tickets-area") ? : "swss-user-tickets-area";
			
			$html .="<div class='swss_protabHolder'>";
			$html .="<a target='_blank' href='$current_url$swss_alias/?swss_action=NewTicket' class='swss_new_ticket_btn swss_button' >".__('Submit New Ticket','sunticket')."</a>";
			$html .="<a target='_blank' href='$current_url$swss_alias' class='swss_button swss_view_all_tickets' >".__('View Tickets','sunticket')."</a>";
			$html .="</div>";
		}
		echo $html;
	}
	
	
	
}
?>