<?php
namespace Elementor;

class Cdb_Testimonials extends Widget_Base {
	
	public function get_name() {
		return 'users-testimonialls';
	}
	
	public function get_title() {
		return  __( 'Testimonials', 'studiare' );
	}
	
	public function get_icon() {
		return 'sc eicon-testimonial-carousel';
	}
	
	public function get_categories() {
		return [ 'studiare' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'studiare' ),
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' => __( 'Title', 'studiare' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'role', [
				'label' => __( 'Role', 'studiare' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'testimonial', [
				'label' => __( 'User Testimonial', 'studiare' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'image', [
				'label' => __( 'User Image', 'studiare' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
            'video', [
                'label' => __( 'User Video', 'studiare' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['video'],
                'default' => [],
            ]
        );
        $repeater->add_control(
            'video_poster', [
                'label' => __( 'Video Poster', 'studiare' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['image'],
                'default' => [],
                'condition' => [
                    'video[url]!' => '',
                ],
            ]
        );
        
        

		
		$this->add_control(
			'list',
			[
				'label' => __( 'Testimonials List', 'studiare' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				/*'default' => [
					[
						'list_title' => __( 'Title #1', 'studiare' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'studiare' ),
					],
					[
						'list_title' => __( 'Title #2', 'studiare' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'studiare' ),
					],
				],*/
				'title_field' => '{{{ title }}}',
			]
		);
		
		$this->add_control(
            'enable_video_popup',
            [
                'label' => __( 'Enable Video Popup', 'studiare' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'studiare' ),
                'label_off' => __( 'No', 'studiare' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'default_video_poster', [
                'label' => __( 'Default Video Poster', 'studiare' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['image'],
                'default' => [],
                'condition' => [
                    'enable_video_popup!' => 'yes',
                ],
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_layout',
			[
				'label' => __( 'Layout', 'studiare' ),
			]
		);
		
		
		$this->add_control(
			'sc_studi_cat_carouseitems_in_desktop',
			[
				'label' => __( 'Columns in desktop', 'studiare' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => '',
                'default' => '4',
			]
		);
		$this->add_control(
			'sc_studi_cat_carouseitems_in_tablet',
			[
				'label' => __( 'Columns in tablet', 'studiare' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => '',
                'default' => '2',
			]
		);
		$this->add_control(
			'sc_studi_cat_carouseitems_in_mobile',
			[
				'label' => __( 'Columns in mobile', 'studiare' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => '',
                'default' => '1',
			]
		);
		$this->add_responsive_control(
            'video_max_height',
            [
                'label' => __( 'Video Max Height', 'studiare' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 220,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-video video' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'enable_video_popup!' => 'yes',
                ],
            ]
        );

		$this->add_control(
			'sc_dots_active_color',
			[
				'label' => __( 'Dots active color', 'studiare' ),
				'label_block' => true,
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-dot.active span' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'sc_dots_normal_color',
			[
				'label' => __( 'Dots normal color', 'studiare' ),
				'label_block' => true,
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-dot span' => 'background: {{VALUE}} !important',
				],
			]
		);
		
		
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        $css_class = "testimonials-wrapper";
       
        
        /*$date  = $settings['date'];
        $size  = $settings['size'] ;
        $style = $settings['style'] ;
        $light = $settings['light'] ;
        $align = $settings['align'] ;*/
        
        $sc_studi_cat_carouseitems_in_desktop = $settings['sc_studi_cat_carouseitems_in_desktop'] ;
        $sc_studi_cat_carouseitems_in_tablet = $settings['sc_studi_cat_carouseitems_in_tablet'] ;
        $sc_studi_cat_carouseitems_in_mobile = $settings['sc_studi_cat_carouseitems_in_mobile'] ;
        
 $jrand=rand(100,10000);       
        if ( $settings['list'] ) {
            ?>
                        <style>
                            .tuimage img { max-width: 112px; margin: 0 auto; border-radius: 20px 5px; box-shadow: -6px 6px #ffffff6e, 6px 13px #ffffff63; }
                            #customers-testimonials<?php echo $jrand; ?> .item {
                                text-align: center;
                                margin-bottom: 50px;
                                padding: 15px;
                                opacity: .2;
                                -webkit-transform: scale3d(0.8, 0.8, 1);
                                transform: scale3d(0.8, 0.8, 1);
                                -webkit-transition: all 0.3s ease-in-out;
                                -moz-transition: all 0.3s ease-in-out;
                                transition: all 0.3s ease-in-out;
                                background-color: #FFF;
                                border-radius: 3px;
                            }
                            #customers-testimonials<?php echo $jrand; ?> .owl-item.active.center .item {
                                opacity: 1;
                                -webkit-transform: scale3d(1.0, 1.0, 1);
                                transform: scale3d(1.0, 1.0, 1);
                                background-color: #FFF;
                            }
                            #customers-testimonials<?php echo $jrand; ?>.owl-carousel .owl-item img {
                                transform-style: preserve-3d;
                                max-width: 112px;
                                margin: 0 auto 17px;
                            }
                            #customers-testimonials<?php echo $jrand; ?> .owl-dots.disabled{display:block;}
                            .commo img {
                                width: 30px !important;
                                height: auto;
                                float: left;
                            }
                            .author-img img {
                                width: 112px !important;
                                height: auto;
                                border-radius: 100%;
                                margin-bottom: 0 !important;
                            }
                        </style>
                        <div class="<?php echo  esc_attr( $css_class );?>">
                            
                        <?php if ( !empty($settings['enable_video_popup']) && $settings['enable_video_popup'] === 'yes' ) : ?>
                            <style>
                                .author-img {
                                    position: relative;
                                    display: inline-block;
                                }
                        
                                .video-popup-btn {
                                    position: absolute;
                                    top: 50%;
                                    left: 50%;
                                    transform: translate(-50%, -50%);
                                    background: rgba(0, 0, 0, 0.6);
                                    padding: 10px;
                                    border-radius: 50%;
                                    cursor: pointer;
                                    display: flex;
                                    align-items: center;
                                    justify-content: center;
                                }
                        
                                .video-popup-btn svg {
                                    width: 40px;
                                    height: 40px;
                                }
                            </style>
                            <?php 
                            $video_play_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24" fill="none">
                                <path d="M13.8876 9.9348C14.9625 10.8117 15.5 11.2501 15.5 12C15.5 12.7499 14.9625 13.1883 13.8876 14.0652C13.5909 14.3073 13.2966 14.5352 13.0261 14.7251C12.7888 14.8917 12.5201 15.064 12.2419 15.2332C11.1695 15.8853 10.6333 16.2114 10.1524 15.8504C9.6715 15.4894 9.62779 14.7336 9.54038 13.2222C9.51566 12.7947 9.5 12.3757 9.5 12C9.5 11.6243 9.51566 11.2053 9.54038 10.7778C9.62779 9.26636 9.6715 8.51061 10.1524 8.1496C10.6333 7.78859 11.1695 8.11466 12.2419 8.76679C12.5201 8.93597 12.7888 9.10831 13.0261 9.27492C13.2966 9.46483 13.5909 9.69274 13.8876 9.9348Z" stroke="#fff" stroke-width="1.5"></path>
                                <path d="M7 3.33782C8.47087 2.48697 10.1786 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 10.1786 2.48697 8.47087 3.33782 7" stroke="#fff" stroke-width="1.5" stroke-linecap="round"></path>
                            </svg>';
                    endif; ?>

                                    
                                    	 <div id="customers-testimonials<?php echo $jrand; ?>" class="owl-carousel"> 
                                    		<?php 
                                    		$class = "testimonial-item";
                                    		foreach (  $settings['list'] as $item ) {
                                    		    $img_alt = !empty($item['image']['alt']) ? esc_attr($item['image']['alt']) : esc_attr($item['title']);
                                                $img = wp_get_attachment_image($item['image']['id'], 'thumbnail', '', array(
                                                    'class' => 'testimonial-avatar-image',
                                                    'alt' => $img_alt
                                                ));
                                				?>
                                				
                                            
                                            <!--start TESTIMONIAL  -->
                                            <div class="item shadow-lg">
                                                <div class="p-4 bg-white rounded"> 
                                                <?php if ( !empty($item['video']['url']) && $settings['enable_video_popup'] !== 'yes' ) : 
                                                    $poster_url = '';
                                                    if (!empty($item['video_poster']['url'])) {
                                                        $poster_url = esc_url($item['video_poster']['url']);
                                                    } elseif (!empty($settings['default_video_poster']['url'])) {
                                                        $poster_url = esc_url($settings['default_video_poster']['url']);
                                                    }
                                                    $video_alt = !empty($item['video']['alt']) ? esc_attr($item['video']['alt']) : esc_attr($item['title']);
                                                    ?>
                                                    <div class="testimonial-video">
                                                        <video width="100%" controls controlsList="nodownload" oncontextmenu="return false;" preload="none" <?php if ($poster_url) { echo 'poster="' . $poster_url . '"'; } ?>>
                                                            <source src="<?php echo esc_url($item['video']['url']); ?>" type="video/mp4">
                                                            <?php echo esc_html(sprintf(__('Video testimonial by %s', 'studiare'), $video_alt)); ?>
                                                        </video>
                                                    </div>
                                                <?php endif; ?>


                                                 <?php if ( $img != '' ) : ?>
                                                    <div class="author-img mr-3">
                                                        <?php echo wp_kses_post( $img ); ?>
                                            
                                                        <?php if ( !empty($item['video']['url']) && $settings['enable_video_popup'] === 'yes' ) : ?>
                                                            <a href="<?php echo esc_url($item['video']['url']); ?>" class="video-popup-btn">
                                                                <?php echo $video_play_icon; ?>
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>

                                                <p class="mb-4 text-muted">	<?php echo do_shortcode( $item['testimonial'] ); ?></p>
                                                <hr>
                                                <div class="d-flex align-items-center">
                                                    
                                                    <div>
                                                <?php if ( $item['title'] !== '' ) { ?>        
                                                    <h6 class="testo_title"><?php echo esc_html( $item['title'] ); ?></h6>
                                                <?php } ?>
                                                <?php if ( $item['role'] !== '' ) { ?>
                                                    <p class="testo_role"><?php echo esc_html( $item['role'] ); ?></p>
                                                <?php } ?>
                                                  </div>
                                                  </div>
                                              </div>
                                              </div>
                                    
                                            <!--END OF TESTIMONIAL  -->
        				<?php
        			}
            		?>
            	</div>
            
            </div>
            <script>
              jQuery(document).ready(function($) {
                            "use strict";
                            //  TESTIMONIALS CAROUSEL HOOK
                            $('#customers-testimonials<?php echo $jrand; ?>').owlCarousel({
                                loop: true,
                                center: true,
                                margin:-38,                   
                                dots:true,
                                autoplayTimeout: 5000,
                                smartSpeed: 450,
                                responsive: {
                                  0: {
                                    items: <?php echo $sc_studi_cat_carouseitems_in_mobile ?>
                                  },
                                  768: {
                                    items: <?php echo $sc_studi_cat_carouseitems_in_tablet ?>
                                  },
                                  1170: {
                                    items: <?php echo $sc_studi_cat_carouseitems_in_desktop ?>
                                  }
                                }
                            });
                        });
              </script>
        <?php
        }
        
        
        
	}
	
	protected function _content_template() {
	 
    }
	
	
}