<?php
# Ticket Settings
Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'Support System', 'studiare' ),
    'id'     => 'tickets_settings',
    'icon'   => 'fal fa-ticket',
    'subsection' => true,
    'fields' => array(
        array(
            'id'      => 'tickets_status',
            'type'    => 'switch',
            'title'   => esc_html__( 'Support System', 'studiare' ),
            'default' => false,
        ),
        array(
            'id'       => 'tickets_in_dashbard_page',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Support System stats in dashboard', 'studiare' ),
            'default'  => true,
            'required' => array('tickets_status', '=', '1'),
        ),
        array(
            'id'       => 'tickets_settings_info',
            'type'     => 'info',
            'style'    => 'info',
            'title'    => esc_html__( 'Additional Settings', 'studiare' ),
            'desc'     => wp_kses_post( sprintf(
                __( 'For more settings, visit the <a href="%s" target="_blank">Santicket Settings</a>.', 'studiare' ),
                admin_url( 'edit.php?post_type=swss_ticket&page=acf-options-ticket-system-options' )
            ) ),
            'required' => array('tickets_status', '=', '1'),
        ),
    )
) );
