<?php
# Dashboard
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Dashboard and Login', 'studiare' ),
    'id'               => 'sc_notification_settings',
    'subsection'       => false,
    'icon'             => 'fal fa-user-cog',
    'fields'           => array()
));

Redux::setSection( $opt_name, array(
    'title'      => esc_html__( 'Login Form', 'studiare' ),
    'id'         => 'sc_login_form',
    'subsection' => true,
    'icon'       => 'fal fa-user-lock',
    'fields'     => array(
        array(
            'id'       => 'show_logo_in_login',
            'type'     => 'switch',
            'title'    => esc_html__('Show Logo in Login and Register Page', 'studiare'),
            'default'  => true,
        ),
        array(
            'id'        => 'login_page_template',
            'type'      => 'select',
            'title'     => esc_html__( 'Login And Register Layout', 'studiare' ),
            'subtitle'  => esc_html__( 'This Layout will Apply on Woocommerce My Account Page', 'studiare' ),
            'options'   => array(
                'temp-01' => esc_html__( 'Layout 1', 'studiare' ),
                'temp-02' => esc_html__( 'Layout 2', 'studiare' ),
                'temp-03' => esc_html__( 'Layout 3', 'studiare' ),
                'default' => esc_html__( 'Woocommerce Default', 'studiare' ),
            ),
            'default'   => 'temp-01',
            'select2'   => array('allowClear' => false)
        ),
        array(
            'id'    => 'login_image',
            'type'  => 'media',
            'desc'  => esc_html__('Upload Image: png, jpg or gif file', 'studiare'),
            'title' => esc_html__('Login/Register Form Image', 'studiare'),
        ),
        array(
            'id'          => 'login-page-main-color',
            'type'        => 'color',
            'title'       => esc_html__( 'Main Color', 'studiare' ),
            'validate'    => 'color',
            'transparent' => false,
            'description' => esc_html__( 'Layout 1 Default Color is  #26a69a - Layout 2 Default Color is  #8224e3', 'studiare' ),
            'output'      => '',
            'default'     => '#8224e3'
        ),
        // New field for redirect after login
        array(
            'id'       => 'login_redirect_type',
            'type'     => 'select',
            'title'    => esc_html__( 'Redirect After Login', 'studiare' ),
            'subtitle' => esc_html__( 'Choose where to redirect users after successful login', 'studiare' ),
            'options'  => array(
                'account'     => esc_html__( 'My Account Page (Default)', 'studiare' ),
                'current'     => esc_html__( 'Current Page', 'studiare' ),
                'custom'      => esc_html__( 'Custom URL', 'studiare' ),
            ),
            'default'  => 'account',
            'select2'  => array('allowClear' => false)
        ),
        // Conditional field for custom redirect URL
        array(
            'id'       => 'login_custom_redirect_url',
            'type'     => 'text',
            'title'    => esc_html__( 'Custom Redirect URL', 'studiare' ),
            'subtitle' => esc_html__( 'Enter a valid URL to redirect users after login', 'studiare' ),
            'default'  => '',
            'required' => array('login_redirect_type', '=', 'custom'),
            'validate' => 'url'
        ),
    )
));

/***
 * OTP Login Register
 **/

Redux::setSection( $opt_name, array(
    'title'      => esc_html__( 'OTP', 'studiare' ),
    'id'         => 'sc_otp_settings',
    'subsection' => true,
    'icon'       => 'fal fa-mobile',
    'fields'     => array(
        array(
            'id'       => 'otp',
            'type'     => 'switch',
            'title'    => esc_html__('Activate OTP', 'studiare'),
            'default'  => false,
        ),
        array(
            'id'       => 'email_login_enabled',
            'type'     => 'switch',
            'title'    => esc_html__('Email Login/Register', 'studiare'),
            'default'  => true,
        ),
        array(
            'id'       => 'compulsion_mobile_num',
            'type'     => 'switch',
            'title'    => esc_html__('Compulsion to register mobile number', 'studiare'),
            'default'  => false,
            'required' => array('otp', '=', 'true'),
        ),
        array(
            'id'       => 'login_priority',
            'type'     => 'button_set',
            'title'    => esc_html__('Login priority', 'studiare'),
            'options'  => array(
                'email'  => esc_html__('With Email', 'studiare'),
                'mobile' => esc_html__('With Mobile', 'studiare'),
            ),
            'default'  => 'email',
            'required' => array('otp', '=', 'true'),
        ),
        array(
            'id'          => 'otp_provider',
            'type'        => 'select',
            'title'       => esc_html__( 'OTP Provider', 'studiare' ),
            'subtitle'    => esc_html__( 'Select your otp provider', 'studiare' ),
            'options'     => array(
                'mellipayamak' => esc_html__( 'Melli Payamak', 'studiare' ),
                'ippanel'      => esc_html__( 'IPPanel', 'studiare' ),
                'farazsms'     => esc_html__( 'Faraz SMS', 'studiare' ),
                'smsir'        => esc_html__( 'SMS.ir', 'studiare' ),
                'suncode'      => esc_html__( 'Suncode', 'studiare' ),
            ),
            'default'     => 'mellipayamak',
            'description' => '',
            'select2'     => array('allowClear' => false),
            'required'    => array('otp', '=', 'true'),
        ),
        array(
            'id'   =>'divider_1',
            'description' => sprintf(__('You can register sms plan from <a target="_blank" href="%s">%s</a>','studiare'), 'https://melipayamak.com/?aff=AB7RE',esc_html__( 'Melli Payamak', 'studiare' )),
            'required' => array('otp_provider', '=', 'mellipayamak'),
            'type' => 'raw'
        ),
        array(
            'id'       => 'mellipayamak_api_address',
            'type'     => 'text',
            'title'    => esc_html__('Mellipayamak Api Address', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'mellipayamak'),
        ),
        
        // ippanel start
                
        array(
            'id'   =>'divider_2',
            'description' => sprintf(__('You can register sms plan from <a target="_blank" href="%s">%s</a>','studiare'), 'https://ippanel.co/?ref=42',esc_html__( 'IPPanel', 'studiare' )),
            'required' => array('otp_provider', '=', 'ippanel'),
            'type' => 'raw'
        ),
        array(
            'id'       => 'ippanel_api_address',
            'type'     => 'text',
            'title'    => esc_html__('Api Address', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'ippanel'),
        ),
        array(
            'id'       => 'ippanel_pattern_code',
            'type'     => 'text',
            'title'    => esc_html__('Pattern Code', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'ippanel'),
        ),
        array(
            'id'       => 'ippanel_pattern_variable',
            'type'     => 'text',
            'title'    => esc_html__('Pattern Variable', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'ippanel'),
        ),
        
        // farazsms start
                
        array(
            'id'   =>'divider_3',
            'description' => sprintf(__('You can register sms plan from <a target="_blank" href="%s">%s</a>','studiare'), 'https://farazsms.com/?ref=3054',esc_html__( 'Faraz SMS', 'studiare' )),
            'required' => array('otp_provider', '=', 'farazsms'),
            'type' => 'raw'
        ),
        array(
            'id'       => 'farazsms_api_address',
            'type'     => 'text',
            'title'    => esc_html__('Api Address', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'farazsms'),
        ),
        array(
            'id'       => 'farazsms_pattern_code',
            'type'     => 'text',
            'title'    => esc_html__('Pattern Code', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'farazsms'),
        ),
        array(
            'id'       => 'farazsms_pattern_variable',
            'type'     => 'text',
            'title'    => esc_html__('Pattern Variable', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'farazsms'),
        ),
        
        // sms.ir start
                
        array(
            'id'   =>'divider_4',
            'description' => sprintf(__('You can register sms plan from <a target="_blank" href="%s">%s</a>','studiare'), 'https://app.sms.ir/auth/sign-up?ref=Z9E33',esc_html__( 'SMS.ir', 'studiare' )),
            'required' => array('otp_provider', '=', 'smsir'),
            'type' => 'raw'
        ),
        array(
            'id'       => 'smsir_api_address',
            'type'     => 'text',
            'title'    => esc_html__('Api Address', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'smsir'),
        ),
        array(
            'id'       => 'smsir_pattern_code',
            'type'     => 'text',
            'title'    => esc_html__('Pattern Code', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'smsir'),
        ),
        array(
            'id'       => 'smsir_pattern_variable',
            'type'     => 'text',
            'title'    => esc_html__('Pattern Variable', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'smsir'),
        ),
        
        array(
            'id'       => 'suncode_api_address',
            'type'     => 'text',
            'title'    => esc_html__('Suncode Api Address', 'studiare'),
            'default'  => '',
            'required' => array('otp_provider', '=', 'suncode'),
        ),
         array(
            'id'       => 'new_user_display_name_type',
            'type'     => 'select',
            'title'    => __('New User Display Name', 'studiare'),
            'subtitle' => __('Choose how the display name for new users should be set.', 'studiare'),
            'options'  => array(
                'mobile' => __('Mobile Number (Default)', 'studiare'),
                'custom' => __('Custom Text', 'studiare'),
            ),
            'default'  => 'mobile',
            'required' => array('otp', '=', 'true'),
        ),
        array(
            'id'       => 'new_user_custom_display_name',
            'type'     => 'text',
            'title'    => __('Custom Display Name', 'studiare'),
            'subtitle' => __('Enter the custom display name for new users.', 'studiare'),
            'default'  => __('New User', 'studiare'),
            'required' => array('new_user_display_name_type', '=', 'custom'),
        ),
    )
));

# Floating Contact Button
Redux::setSection( $opt_name, array(
    'title'      => esc_html__( 'Account Page', 'studiare' ),
    'id'         => 'sc_account_page',
    'subsection' => true,
    'icon'       => 'fal fa-id-card',
    'fields'     => array(
        array(
            'id'       => 'myaccount_page_fullwidth',
            'type'     => 'switch',
            'title'    => esc_html__('Make My Account Page Full Width', 'studiare'),
            'default'  => false,
        ),
        array(
            'id'        => 'my_account_page_template',
            'type'      => 'select',
            'title'     => esc_html__( 'Dashboard Page Layout', 'studiare' ),
            'subtitle'  => esc_html__( 'My Account Page Layout and How to Show Menus', 'studiare' ),
            'options'   => array(
                'myaccount-temp-01' => esc_html__( 'Show Menu at Top', 'studiare' ),
                'myaccount-temp-02' => esc_html__( 'Show Menu at Left', 'studiare' ),
                'myaccount-temp-03' => esc_html__( 'Show Menu at Top and Left', 'studiare' ),
            ),
            'default'   => 'myaccount-temp-01',
            'select2'   => array('allowClear' => false)
        ),
        array(
            'id'       => 'sc_notif_to_show',
            'title'    => esc_html__( 'Number of Notifications in Dropdown Menu', 'studiare' ),
            'type'     => 'text',
            'default'  => '5',
        ),
        array(
            'id'       => 'sc_comments_per_page',
            'title'    => esc_html__( 'Comments Per Page', 'studiare' ),
            'type'     => 'text',
            'default'  => '5',
        ),
        array(
            'id'       => 'enable_profile_picture_upload',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Profile Picture Upload', 'studiare'),
            'subtitle' => esc_html__('Enable or disable the profile picture upload feature in the account page.', 'studiare'),
            'default'  => true,
        ),
        array(
            'id'       => 'sc_custom_dashboard_page',
            'type'     => 'select',
            'multi'    => false,
            'data'     => 'posts',
            'args'     => array(
                'post_type'   => array( 'page' ),
                'numberposts' => -1,
                'post_status' => array( 'publish', 'private' )
            ),
            'title'    => esc_html__( 'Custom Dashboard Page', 'studiare' ),
            'desc'     => esc_html__( 'Select a page to display its content in the dashboard instead of the default content.', 'studiare' ),
            'default'  => '',
        ),
        array(
            'id'     => 'account_page-tabs-section',
            'type'   => 'section',
            'title'  => esc_html__('Account Tab Options', 'studiare'),
            'indent' => true
        ),
        array(
            'id'        => 'sc_active_dash_tab',
            'type'      => 'select',
            'title'     => esc_html__( 'Default Tab', 'studiare' ),
            'options'   => array(
                'notifs'      => esc_html__( 'Latest Notifications', 'studiare' ),
                'statics'     => esc_html__( 'Website Statistics', 'studiare' ),
                'scCustomTab' => esc_html__( 'Custom Tab', 'studiare' ),
            ),
            'default'   => 'notifs',
            'select2'   => array('allowClear' => false)
        ),
        array(
            'id'       => 'show_latest_notifs_tab',
            'type'     => 'switch',
            'title'    => esc_html__('Show Latest Notifications Tab', 'studiare'),
            'default'  => true,
        ),
        array(
            'id'       => 'show_statistics_tab',
            'type'     => 'switch',
            'title'    => esc_html__('Show Website Statistics Tab', 'studiare'),
            'default'  => true,
        ),
        array(
            'id'       => 'show_custom_tab',
            'type'     => 'switch',
            'title'    => esc_html__('Show Custom Tab', 'studiare'),
            'default'  => false,
        ),
        array(
            'id'       => 'dash_custom_tab_title',
            'title'    => esc_html__( 'Custom Tab Title', 'studiare' ),
            'type'     => 'text',
            'required' => array('show_custom_tab', '=', '1'),
            'default'  => esc_html__( 'Custom Tab', 'studiare' ),
        ),
        array(
            'id'       => 'dash_custom_tab_content',
            'title'    => esc_html__( 'Custom Tab Content', 'studiare' ),
            'type'     => 'editor',
            'required' => array('show_custom_tab', '=', '1'),
            'default'  => '',
        ),
        array(
            'id'          => 'sc_custom_logout_url',
            'type'        => 'text',
            'title'       => esc_html__( 'Logout URL', 'studiare' ),
            'description' => esc_html__( 'Redirect user after logout from my account page', 'studiare' ),
        ),
        array(
            'id'     => 'account_page_menus-section',
            'type'   => 'section',
            'title'  => esc_html__('Account Menu Options', 'studiare'),
            'indent' => true
        ),
        array(
            'id'       => 'sc_select_account_page_menus',
            'type'     => 'select',
            'multi'    => true,
            'data'     => 'custom',
            'args'     => array(),
            'title'    => esc_html__('Disable Account Page Menus', 'studiare'),
            'subtitle' => esc_html__('Select the menus to disable in the account page.', 'studiare'),
            'options'  => get_account_page_menus(),
        ),
        array(
            'id'       => 'sc_disable_menu_from_endpoint',
            'type'     => 'switch',
            'title'    => esc_html__('Remove Menu from Endpoint', 'studiare'),
            'default'  => false,
            'required' => array('sc_select_account_page_menus', '!=', ''),
            'subtitle' => esc_html__('Choose whether to remove the menu from the endpoint as well as the list.', 'studiare'),
        ),
        array(
            'id'          => 'custom_account_menus',
            'type'        => 'repeater',
            'group_values'=> true,
            'title'       => esc_html__('Custom Account Menus', 'studiare'),
            'subtitle'    => esc_html__('Add custom menus to WooCommerce account page.', 'studiare'),
            'fields'      => array(
                array(
                    'id'    => 'menu_title',
                    'type'  => 'text',
                    'title' => esc_html__('Menu Title', 'studiare'),
                ),
                array(
                    'id'    => 'menu_slug',
                    'type'  => 'text',
                    'title' => esc_html__('Menu Slug (Unique)', 'studiare'),
                ),
                array(
                    'id'    => 'menu_icon',
                    'type'  => 'text',
                    'title' => esc_html__('Menu Icon (FontAwesome)', 'studiare'),
                ),
                array(
                    'id'      => 'menu_content_type',
                    'type'    => 'select',
                    'title'   => esc_html__('Content Type', 'studiare'),
                    'options' => array(
                        'editor' => esc_html__('Text Editor', 'studiare'),
                        'page'   => esc_html__('Select Page', 'studiare'),
                    ),
                    'default' => 'editor',
                ),
                array(
                    'id'    => 'menu_content_editor',
                    'type'  => 'editor',
                    'title' => esc_html__('Menu Content (if Editor selected)', 'studiare'),
                ),
                array(
                    'id'    => 'menu_content_page',
                    'type'  => 'select',
                    'data'  => 'pages',
                    'title' => esc_html__('Select Page (if Page selected)', 'studiare'),
                ),
            ),
        ),
    )
));

function get_account_page_menus() {
    $menu_list = array();

    if (class_exists('WooCommerce')) {
        $menu_items = wc_get_account_menu_items();
        foreach ($menu_items as $key => $menu_item) {
            $menu_list[$key] = $menu_item;
        }
    } else {
        $menu_list = array('none' => esc_html__('WooCommerce is not active', 'studiare'));
    }

    return $menu_list;
}
