<?php
# Courses Settings
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'Product and courses', 'studiare' ),
	'id' => 'courses',
	'icon' => 'fal fa-shopping-cart',

) );

Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Product and courses', 'studiare' ),
	'id'               => 'course_settings',
	'subsection'       => true,
	'icon' => 'fal fa-store-alt',
	'fields' => array(
		array(
			'id'        => 'shop_sidebar',
			'type'      => 'image_select',
			'title'     => esc_html__( 'Sidebar Position', 'studiare' ),
			'default'   => 'left',
			'options'   => array(
				'none'      => array(
					'alt'   => esc_html__( 'Without Sidebar', 'studiare' ),
					'img'   => ReduxFramework::$_url.'assets/img/1col.png'
				),
				'left'      => array(
					'alt'   => esc_html__( 'Right Sidebar', 'studiare' ),
					'img'   => ReduxFramework::$_url.'assets/img/2cr.png'
				),
				'right'      => array(
					'alt'   => esc_html__( 'Left Sidebar', 'studiare' ),
					'img'  => ReduxFramework::$_url.'assets/img/2cl.png'
				),
			)
		),
		array(
			'id'        => 'place_of_discriptions_of_cats',
			'type'      => 'button_set',
			'title'     => esc_html__( 'Category Description Position', 'studiare' ),
			'subtitle'  => esc_html__( 'Show Category Description Before or After Category Products.', 'studiare' ),
			'options'   => array(
				'top' => esc_html__( 'Top', 'studiare' ),
				'bottom' => esc_html__( 'Bottom', 'studiare' ),
			),
			'default'   => 'bottom',
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'        => 'courses_columns',
			'type'      => 'select',
			'title'     => esc_html__( 'Product Columns', 'studiare' ),
			'options'   => array(
				'2' => esc_html__( '2-Column', 'studiare' ),
				'3' => esc_html__( '3-Column', 'studiare' ),
				'4' => esc_html__( '4-Column', 'studiare' ),
			),
			'default'   => '3',
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'        => 'courses_layout_mode',
			'type'      => 'select',
			'title'     => esc_html__( 'Products View Layout', 'studiare' ),
			'options'   => array(
				'grid' => esc_html__( 'Grid View', 'studiare' ),
				'list' => esc_html__( 'List View', 'studiare' ),
			),
			'default'   => 'grid',
			'select2'   => array('allowClear' => false)
		),
		array(
			'id'        => 'shop_pro_image_size',
			'type'      => 'select',
			'title'     => esc_html__( 'Product Image Size', 'studiare' ),
			'options'   => array(
				'studiare-course-thumb' => esc_html__( 'Theme Default', 'studiare' ),
				'thumbnail' => esc_html__( 'Wordpress Thumbnail', 'studiare' ),
				'medium'    => esc_html__( 'Wordpress Medium', 'studiare' ),
				'large'     => esc_html__( 'Wordpress Large', 'studiare' ),
				'full'      => esc_html__( 'Wordpress Full', 'studiare' ),
				'woocommerce_thumbnail'      => esc_html__( 'Woocommerce Thumbnail', 'studiare' ),
				'woocommerce_single'      => esc_html__( 'Woocommerce Single', 'studiare' ),
			),
			'default'   => 'studiare-course-thumb',
			'select2'   => array('allowClear' => false)
		),
		//since version 13.2 add no image option
		array(
			'id'        => 'product_no_image',
			'type'      => 'select',
			'title'     => esc_html__( 'No Image Product', 'studiare' ),
			'options'   => array(
				'noimage' => esc_html__( 'No Image', 'studiare' ),
				'default' => esc_html__( 'Default', 'studiare' ),
				'custom'  => esc_html__( 'Custom Image', 'studiare' ),
			),
			'default'   => 'default',
			'select2'   => array('allowClear' => false)
		),
		array (
			'id' => 'product_no_image_custom',
			'type' => 'media',
			'desc' => esc_html__( 'Upload image: png, jpg, jpeg', 'studiare' ),
			'operator' => 'and',
			'title' => esc_html__( 'Custom Image', 'studiare' ),
			'subtitle'  => '',
			'required' => array('product_no_image', '=', 'custom'),
		),
		array(
			'id'       => 'shop_per_page',
			'type'     => 'spinner',
			'title'    => esc_html__( 'Number of Products Per Page', 'studiare' ),
			'default'  => '6',
			'min'      => '1',
			'max'      => '20',
		),
		array(
			'id'       => 'archive_teacher_view',
			'type'     => 'button_set',
			'title'    => esc_html__('Teacher', 'studiare'),
			'subtitle' => esc_html__('Select How to view Teachers On store pages and categories', 'studiare'),
			'options'  => array(
				'disable'  => esc_html__( 'Hide', 'studiare' ),
				'list'  => esc_html__( 'Teacher Name', 'studiare' ),
				'avatar'  => esc_html__( 'Teacher Avatar', 'studiare' ),
			),
			'default' => 'list',
		),
		array(
			'id'       => 'product_rating_view',
			'type'     => 'switch',
			'title'    => esc_html__('Product Rating', 'studiare'),
			'subtitle'  => esc_html__( 'Show Product Rating On store pages and categories', 'studiare' ),
			'default'  => true,
		),
		array(
			'id'       => 'product_stars',
			'type'     => 'switch',
			'title'    => esc_html__('Show Product Rating as Stars', 'studiare'),
			'subtitle'  => esc_html__( 'Enable this Option to Show Stars instead of Numbers for Product Rating', 'studiare' ),
			'default'  => true,
		),
		array(
			'id'       => 'product_descr_shop_page',
			'type'     => 'switch',
			'title'    => esc_html__('Product Description', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'default'  => true,
		),
		array(
			'id'       => 'toman_as_image',
			'type'     => 'switch',
			'title'    => esc_html__('Replace toman with image of toman', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'default'  => false
		),
		array(
			'id'       => 'sc_shop_page_addtocart',
			'type'     => 'switch',
			'title'    => esc_html__('Add to Cart Button', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'default'  => false
		),
		array(
			'id'       => 'sc_shop_page_qv',
			'type'     => 'switch',
			'title'    => esc_html__('Quick View Icon', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'desc'     => __( 'Note: Only Works with <a href="https://wordpress.org/plugins/woo-smart-quick-view/" target="_blank">"WPC Smart Quick View for WooCommerce"</a> Plugin', 'studiare' ),
			'default'  => false
		),
		array(
			'id'       => 'sc_shop_page_aw',
			'type'     => 'switch',
			'title'    => esc_html__('Add to Whishlist Icon', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'desc'     => __( 'Note: Only Works with <a href="https://wordpress.org/plugins/woo-smart-wishlist/" target="_blank">"WPC Smart Wishlist for WooCommerce"</a> Plugin', 'studiare' ),
			'default'  => true
		),
		array(
			'id'       => 'product_danshjou_icon_view',
			'type'     => 'switch',
			'title'    => esc_html__('Display the number of students / buyers', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'default'  => true
		),
		array(
			'id'       => 'product_sc_loop_main_feature',
			'type'     => 'switch',
			'title'    => esc_html__('Display course flagship feature', 'studiare'),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'default'  => true
		),
		array(
			'id'       => 'product_category_border',
			'type'     => 'switch',
			'title'    => esc_html__('The bottom colored line of products', 'studiare'),
			'subtitle'  => esc_html__( 'Displaying the bottom color line of products in the store view and Elementor add-ons based on the color selected in the settings of each category', 'studiare' ),
			'default'  => true
		),
		array(
			'id'       => 'free_or_call_for_price',
			'type'     => 'switch',
			'title'    => esc_html__('Free display for products that do not have a price', 'studiare'),
			'subtitle'  => esc_html__( 'If this option is not active, the call button will be substituted for the price', 'studiare' ),
			'default'  => true,
		),
		array(
			'id'        => 'danshjou_icon',
			'type'      => 'button_set',
			'title'     => esc_html__( 'The default icon for number of students', 'studiare' ),
			'subtitle'  => esc_html__( 'On store pages and categories', 'studiare' ),
			'options'   => array(
				'fal fa-user-chart' => esc_html__( 'User Chart Icon', 'studiare' ),
				'fal fa-user-check' => esc_html__( 'User Check Icon', 'studiare' ),
				'fal fa-user' => esc_html__( 'User Icon', 'studiare' ),
				'fal fa-user-alt' => esc_html__( 'User Alt Icon', 'studiare' ),
				'fal fa-user-circle' => esc_html__( 'User Circle Icon', 'studiare' ),
				'fal fa-users-class' => esc_html__( 'Users Class Icon', 'studiare' ),

			),
			'default'   => 'fal fa-users-class',
			'select2'   => array('allowClear' => false),
			'required' => array('product_danshjou_icon_view', '=', '1')
		),
		array(
            'id'       => 'exclude_products_shop',
            'type'     => 'switch',
            'title'    => esc_html__('Exclude Products from Shop Page', 'studiare'),
            'subtitle' => esc_html__('Enable this option to exclude specific products or categories from the shop page.', 'studiare'),
            'default'  => false
        ),
        
        array(
            'id'       => 'exclude_product_cats',
            'type'     => 'select',
            'multi'    => true,
            'data'     => 'terms',
            'args'     => array('taxonomies' => 'product_cat', 'args' => array()),
            'title'    => esc_html__('Exclude Categories', 'studiare'),
            'subtitle' => esc_html__('Select categories to exclude products from.', 'studiare'),
            'required' => array('exclude_products_shop', '=', '1'),
        ),
        
        array(
            'id'       => 'exclude_specific_products',
            'type'     => 'select',
            'multi'    => true,
            'data'     => 'posts',
            'args'     => array('post_type' => 'product', 'posts_per_page' => -1),
            'title'    => esc_html__('Exclude Specific Products', 'studiare'),
            'subtitle' => esc_html__('Select specific products to exclude.', 'studiare'),
            'required' => array('exclude_products_shop', '=', '1'),
        ),
        
        array(
            'id'       => 'show_excluded_in_archive',
            'type'     => 'switch',
            'title'    => esc_html__('Show Excluded Products in Category Archive', 'studiare'),
            'subtitle' => esc_html__('If enabled, excluded products will still appear in their category archive pages.', 'studiare'),
            'default'  => false,
            'required' => array('exclude_specific_products', '!=', ''),
        ),
        array(
            'id'       => 'show_custom_shop_description',
            'type'     => 'button_set',
            'title'    => esc_html__('Show Custom Shop Description', 'studiare'),
            'options'  => array(
                'disabled'  => esc_html__('Disable', 'studiare'),
                'top'       => esc_html__('show top', 'studiare'),
                'bottom'    => esc_html__('show bottom', 'studiare'),
            ),
            'default'  => 'disabled',
        ),
        array(
            'id'       => 'custom_shop_description_content',
            'title'    => esc_html__( 'Custom Shop Description Content', 'studiare' ),
            'type'     => 'editor',
            'required' => array('show_custom_shop_description', '!=', 'disabled'),
            'default'  => '',
        ),

	)
) );
//add by suncode start
Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Single Product/Course', 'studiare' ),
	'id'               => 'single_course_settings',
	'subsection'       => true,
	'icon' => 'fal fa-money-check',
	'fields' => array(
	    array(
			'id'        => 'single_product_layout',
			'type'      => 'select',
			'title'     => esc_html__( 'Single Product/Course Layout', 'studiare' ),
			'options'   => array(
				'layout-01' => esc_html__( 'Layout 1', 'studiare' ),
				'layout-02' => esc_html__( 'Layout 2', 'studiare' ),
				'layout-03' => esc_html__( 'Layout 3', 'studiare' ),
				'layout-04' => esc_html__( 'Layout 4', 'studiare' ),
				'layout-05' => esc_html__( 'Layout 5', 'studiare' ),
			),
			'default'  => 'layout-01',
		),
		 array(
			'id'       => 'product_sidebar_position',
			'type'     => 'switch',
			'title'    => esc_html__('Sidebar Position', 'studiare'),
			'default'  => false,
			'on'       => esc_html__( 'Left Sidebar', 'studiare' ),
			'off'      => esc_html__( 'Right Sidebar', 'studiare' ),
			'desc'     => __( 'Works with Layout 1', 'studiare' ),
		),
		array(
			'id'       => 'product_meta_info_top_stuts',
			'type'     => 'switch',
			'title'    => esc_html__('Show Information at the Top Single Product', 'studiare'),
			'desc'     => __( 'Works with Layout 1', 'studiare' ),
			'default'  => false
		),
		array(
			'id'       => 'show_fullscreen_mode_button',
			'type'     => 'switch',
			'title'    => esc_html__('Show Fullscreenmode button', 'studiare'),
			'default'  => false
		),
		array(
			'id'       => 'related_course_product',
			'type'     => 'switch',
			'title'    => esc_html__('Show Related Products', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'single_fixed_information',
			'type'     => 'switch',
			'title'    => esc_html__('Show Sticky Info', 'studiare'),
			'subtitle'    => esc_html__('Display buyer information and add to shopping cart as a sticker at the bottom of the page', 'studiare'),
			'default'  => true
		),

		array(
			'id'       => 'product_single_sc_show_buyers',
			'type'     => 'switch',
			'title'    => esc_html__('Show buyers list', 'studiare'),
			'subtitle'  => esc_html__( 'Show buyers list only for admins', 'studiare' ),
			'default'  => true,
		),
		array(
            'id' => 'prerequisites-options-section',
            'type' => 'accordion',
            'title' => esc_html__('Prerequisites Options', 'studiare'),
            'subtitle' => esc_html__('Settings for product prerequisites display and behavior', 'studiare'),
            'position' => 'start'
        ),
        array(
            'id' => 'prerequisites_enabled',
            'type' => 'switch',
            'title' => esc_html__('Enable Prerequisites System', 'studiare'),
            'desc' => esc_html__('Enable or disable the prerequisites system for products.', 'studiare'),
            'default' => false
        ),
        array(
            'id' => 'prerequisites_display_location',
            'type' => 'select',
            'title' => esc_html__('Prerequisites Display Location', 'studiare'),
            'desc' => esc_html__('Choose where to display the prerequisites on the single product page.', 'studiare'),
            'options' => array(
                'in_tabs' => esc_html__('In Product Tabs (Layouts 4 and 5)', 'studiare'),
                'before_add_to_cart' => esc_html__('Before Add to Cart Button', 'studiare'),
                'before_content' => esc_html__('Before Product Content', 'studiare'),
                'after_content' => esc_html__('After Product Content', 'studiare'),
                'in_short_description' => esc_html__('In Short Description', 'studiare'),
            ),
            'default' => 'in_tabs',
            'required' => array('prerequisites_enabled', '=', true)
        ),
        array(
            'id' => 'prerequisites_title_tag',
            'type' => 'select',
            'title' => esc_html__('Prerequisites Title Tag', 'studiare'),
            'desc' => esc_html__('Select the HTML tag for the prerequisites title.', 'studiare'),
            'options' => array(
                'h1' => 'H1',
                'h2' => 'H2',
                'h3' => 'H3',
                'h4' => 'H4',
                'h5' => 'H5',
                'h6' => 'H6',
                'p' => 'Paragraph (P)'
            ),
            'default' => 'h4',
            'required' => array('prerequisites_enabled', '=', true)
        ),
        array(
            'id' => 'prerequisites_title_text',
            'type' => 'text',
            'title' => esc_html__('Prerequisites Title Text', 'studiare'),
            'desc' => esc_html__('Enter the title for the prerequisites section.', 'studiare'),
            'default' => esc_html__('Prerequisites', 'studiare'),
            'required' => array('prerequisites_enabled', '=', true)
        ),
        array(
            'id' => 'prerequisites_description',
            'type' => 'textarea',
            'title' => esc_html__('Prerequisites Description', 'studiare'),
            'desc' => esc_html__('Enter an optional description to display above the prerequisites list.', 'studiare'),
            'default' => '',
            'required' => array('prerequisites_enabled', '=', true)
        ),
        array(
            'id' => 'opt-accordion-end-prerequisites',
            'type' => 'accordion',
            'position' => 'end'
        ),
		array( 
        'id' => 'course-builder-single-product-options-section',
        'type' => 'accordion',
        'title' => esc_html__('Course Builder Options', 'studiare'),
        'subtitle'     => esc_html__('Course Builder Options for non-elementor lesson and quize', 'studiare'),
        'position'  => 'start'
        ),
        array(
            'id'       => 'sc_lesson_number_auto',
            'type'     => 'switch',
            'title'    => esc_html__('Auto Lesson Numbering', 'studiare'),
            'default'  => false
        ),
        array(
            'id'       => 'sc_lessons_display_in_tab',
            'type'     => 'switch',
            'title'    => esc_html__('Display Lessons in Tab', 'studiare'),
            'desc'     => esc_html__('Enable to display lessons in a WooCommerce tab instead of at the end of the content. This feature is compatible with layouts 4 and 5.', 'studiare'),
            'default'  => false
        ),
        array(
            'id'       => 'sc_lock_lessons_based_on_quiz',
            'type'     => 'switch',
            'title'    => esc_html__('Lock Lessons Based on Quiz Result', 'studiare'),
            'desc'     => esc_html__('Enable to lock lessons and quizzes until the user passes the previous quizzes in the course.', 'studiare'),
            'default'  => false
        ),
        array(
            'id'       => 'sc_lock_lessons_scope',
            'type'     => 'select',
            'title'    => esc_html__('Lesson Locking Scope', 'studiare'),
            'desc'     => esc_html__('Choose whether lesson locking applies only within the same section or to all items after a quiz.', 'studiare'),
            'options'  => array(
                'within_section' => esc_html__('Within Section', 'studiare'),
                'all_items'      => esc_html__('All Items', 'studiare'),
            ),
            'default'  => 'all_items',
        ),
        array(
            'id'       => 'sc_always_allow_first_item',
            'type'     => 'switch',
            'title'    => esc_html__('Always Allow First Item', 'studiare'),
            'desc'     => esc_html__('If enabled, the first item (either in the entire course or in each section, depending on the scope) will always be accessible.', 'studiare'),
            'default'  => true
        ),
		
		
        array(
                'id'        => 'opt-accordion-end-0',
                'type'      => 'accordion',
                'position'  => 'end'
        ),
		array( 
        'id' => 'single-product-meta-section',
        'type' => 'accordion',
        'title' => esc_html__('single product meta', 'studiare'),
        'subtitle' => esc_html__('options for single product meta.', 'studiare'),
        'position'  => 'start',    
        ),
        array(
			'id'       => 'product_meta_info_list',
			'type'     => 'switch',
			'title'    => esc_html__('Show Product Meta', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'product_buyers_insingle',
			'type'     => 'switch',
			'title'    => esc_html__('Display the number of students / buyers', 'studiare'),
			'subtitle'  => esc_html__( 'In Singel Product/Course', 'studiare' ),
			'default'  => true
		),
		
		array(
			'id'       => 'product_single_sc_single_navbar',
			'type'     => 'switch',
			'title'    => esc_html__('Show Navigation', 'studiare'),
			'default'  => false
		),
		array(
			'id'       => 'product_meta_info_comment_number',
			'type'     => 'switch',
			'title'    => esc_html__('Show Number of Comments', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'product_meta_info_list_2',
			'type'     => 'switch',
			'title'    => esc_html__('Show additional product features', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'product_meta_info_list_date_published',
			'type'     => 'switch',
			'title'    => esc_html__('Show the release date of the product', 'studiare'),
			'default'  => true,
			'required' => array('product_meta_info_list_2', '=', '1')
		),
		array(
			'id'       => 'product_meta_info_list_date_modified',
			'type'     => 'switch',
			'title'    => esc_html__('Show the update date of the product', 'studiare'),
			'default'  => true,
			'required' => array('product_meta_info_list_2', '=', '1')
		),
		array(
			'id'       => 'product_meta_info_list_stars',
			'type'     => 'switch',
			'title'    => esc_html__('Show users point', 'studiare'),
			'default'  => true,
			'required' => array('product_meta_info_list_2', '=', '1')
		),
		array(
			'id'       => 'product_meta_info_list_cats',
			'type'     => 'switch',
			'title'    => esc_html__('Show Categories', 'studiare'),
			'default'  => true,
			'required' => array('product_meta_info_list_2', '=', '1')
		),
		array(
			'id'       => 'product_meta_info_list_tags',
			'type'     => 'switch',
			'title'    => esc_html__('Show Tags', 'studiare'),
			'default'  => true,
			'required' => array('product_meta_info_list_2', '=', '1')
		),
		array(
			'id'       => 'product_meta_info_list_short_link',
			'type'     => 'switch',
			'title'    => esc_html__('Show Shortlink', 'studiare'),
			'default'  => true,
			'required' => array('product_meta_info_list_2', '=', '1')
		),
		array(
			'id'       => 'product_meta_info_teacher_profile',
			'type'     => 'switch',
			'title'    => esc_html__('Show Teacher', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'product_meta_info_teacher_about',
			'type'     => 'switch',
			'required'  => array('product_meta_info_teacher_profile', '=', '1'),
			'title'    => esc_html__('Show Teacher Bio', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'product_meta_info_teacher_other_courses',
			'type'     => 'switch',
			'required'  => array('product_meta_info_teacher_profile', '=', '1'),
			'title'    => esc_html__('Show Other Teacher Courses', 'studiare'),
			'default'  => true
		),          
        array(
                'id'        => 'opt-accordion-end-1',
                'type'      => 'accordion',
                'position'  => 'end'
        ),
		
		
		
		array( 
        'id' => 'single-product-style-section',
        'type' => 'accordion',
        'title' => esc_html__('single product styles', 'studiare'),
        'subtitle' => esc_html__('options for styling single product.', 'studiare'),
        'position'  => 'start',    
        ),
		array(
			'id'       => 'single_add_to_cart_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Single Add To Cart Button Color', 'studiare' ),
			'output'   => array('color' => 'button.single_add_to_cart_button.button.alt, .sc_studi_btm_addtocart_fixed_btn_holder .button'),
			'default'  => '#fff',
		),
		array(
			'id'       => 'single_add_to_cart_background',
			'type'     => 'color',
			'title'    => esc_html__( 'Single Add To Cart Button Background Color', 'studiare' ),
			'output'   => array('background' => 'button.single_add_to_cart_button.button.alt, .sc_studi_btm_addtocart_fixed_btn_holder .button, .sc-add-to-cart-four a'),
			'default'  => '#4CAF50',
		),
		array(
			'id'       => 'sc--amazing-offer-bg',
			'type'     => 'background',
			'title'    => esc_html__( 'Amazing Offer Background', 'studiare' ),
			'output'   => '.product-info-box.sc-amazing-offer,.woosw-area .woosw-inner .woosw-content .woosw-content-top,.woosw-area .woosw-inner .woosw-content .woosw-content-bot',
			'default'  => array(
				'background-color' => '#e91e63', //'#ffc107',
			)
		),
		array(
			'id'       => 'sc--amazing-offer-txt',
			'type'     => 'color',
			'title'    => esc_html__( 'Amazing Offer Text Color', 'studiare' ),
			'output'   => array('color' => '.product-info-box.sc-amazing-offer'),
			'default'  => '#ffffff',
		),
		
		array(
			'id'       => 'sc--amazing-offer-txt-disvalue',
			'type'     => 'color',
			'title'    => esc_html__( 'Amazing Offer Text Color Amount', 'studiare' ),
			'output'   => array('color' => '.sc-amazing-offer-discount'),
			'default'  => '#E91E63',
		),
		
		
		array(
			'id'       => 'lesson_header_color',
			'type'     => 'color_gradient',
			'title'    => esc_html__('Course title color', 'studiare'),
			 'validate' => 'color',
			 'output'         => '.course-section-title',
			'default'  => array(
            'from' => '#39DAA9',
            'to'   => '#13CE92', 
        ),
		),
		array(
			'id'       => 'lesson_header_active_color',
			'type'     => 'color_gradient',
			'title'    => esc_html__('Active Course title color', 'studiare'),
			 'validate' => 'color',
			 'output'         => '.sc-course-lesson-toggle-wrapper.active_tab_by_suncode .course-section-title, .course-section-title:hover',
			'default'  => array(
            'from' => '#2e3e77',
            'to'   => '#3F51B5', 
        ),
		),
		array(
			'id'       => 'lesson_header_icon_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Course title Icon color', 'studiare' ),
			'output'   => array('color' => '.sc-course-lesson-toggle i'),
			'default'  => '#009688',
		),
		array(
			'id'       => 'lesson_header_icon_active_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Active Course title Icon color', 'studiare' ),
			'output'   => array('color' => '.sc-course-lesson-toggle-wrapper.active_tab_by_suncode .sc-course-lesson-toggle i'),
			'default'  => '#3F51B5',
		),
		array(
			'id'       => 'private_lesson_message_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Private lesson Message color', 'studiare' ),
			'output'   => array('color' => '.lessonaccessdenied'),
			'default'  => '#7d7e7f',
		),
		array(
			'id'       => 'private_lesson_message_bg_color',
			'type'     => 'background',
			'title'    => esc_html__( 'Private lesson Message Background color', 'studiare' ),
			'output'   => '.lessonaccessdenied',
			'default'  => array(
				'background-color' => 'transparent', 
			)
		),
		array(
                'id'        => 'opt-accordion-end-2',
                'type'      => 'accordion',
                'position'  => 'end'
        ),
		
		
		array( 
        'id' => 'single-product-custom-cart-text-section',
        'type' => 'accordion',
        'title' => esc_html__('single product custom text', 'studiare'),
        'subtitle' => esc_html__('this options will apply to all products. you can change cart texts for individual proudcts from editing every single product', 'studiare'),
        'position'  => 'start'
        ),
		array(
			'id'       => 'private_lesson_message',
			'type'     => 'text',
			'title'    => esc_html__('Message for Private lessons', 'studiare'),
			'subtitle'    => esc_html__('If you checked the private lesson, this message shows to non-buyer users.', 'studiare'),
			'default'  => esc_html__( 'This lesson is private, for full access to all lessons you need to buy this course.', 'studiare' ),
		),
		array(
			'id'       => 'login_toast_message',
			'type'     => 'text',
			'title'    => esc_html__('Message to enter the site', 'studiare'),
			'subtitle'    => esc_html__('If you are not logged in to the site, you will encounter this message to download user files.', 'studiare'),
			'default'  => esc_html__('You must log in to your account to download this file.', 'studiare'),
		),
		array(
			'id'       => 'login_toast_title',
			'type'     => 'text',
			'title'    => esc_html__('Message title to enter the site', 'studiare'),
			'default'  => esc_html__('Note', 'studiare'),
		),
		array(
			'id'       => 'bought_toast_message',
			'type'     => 'text',
			'title'    => esc_html__('The message of the need to purchase a product to download', 'studiare'),
			'subtitle'    => esc_html__('If the user has not purchased the product, he/she will get this message by clicking on the product title or the download button.', 'studiare'),
			'default'  => esc_html__('To download this file, you must purchase the product', 'studiare'),
		),
		array(
			'id'       => 'bought_toast_title',
			'type'     => 'text',
			'title'    => esc_html__('The title of the message is the need to purchase the product to download', 'studiare'),
			'default'  => esc_html__('Note', 'studiare'),
		),
		array(
			'id'       => 'product_single_outstock',
			'type'     => 'switch',
			'title'    => esc_html__('Display the message of the end of the capacity', 'studiare'),
			'subtitle'  => esc_html__( 'Message of capacity depletion for in-person products', 'studiare' ),
			'default'  => true
		),
		array(
			'id'       => 'product_single_outstock_message',
			'type'     => 'text',
			'required'  => array('product_single_outstock', '=', '1'),
			'title'    => esc_html__(' message of the end of the capacity', 'studiare'),
			'subtitle'  => esc_html__( 'Message of capacity depletion for in-person products', 'studiare' ),
			'default'  => esc_html__('The capacity is over!', 'studiare'),
		),
		array(
			'id'       => 'product_single_sc_add_to_cart_text',
			'type'     => 'text',
			'title'    => esc_html__('Add to Cart Button Text', 'studiare'),
			'default'  => esc_html__('Add to Cart', 'studiare'),
		),
		array(
			'id'       => 'product_single_sc_added_to_cart_text',
			'type'     => 'text',
			'title'    => esc_html__('Add to Cart Button Text for the Product Placed in the Cart', 'studiare'),
			'default'  => esc_html__('The course is now available in the shopping cart', 'studiare'),
		),
		array(
			'id'       => 'product_single_sc_purchased_producct_text',
			'type'     => 'text',
			'title'    => esc_html__('Add to Cart Button Text for the Product that has Been Purchased', 'studiare'),
			'default'  => esc_html__('You are a student of this course', 'studiare'),
		),
		array(
                'id'        => 'opt-accordion-end-3',
                'type'      => 'accordion',
                'position'  => 'end'
        ),
		array( 
        'id' => 'other-single-product-options-section',
        'type' => 'accordion',
        'title' => esc_html__('Other Options', 'studiare'),
        'position'  => 'start'
        ),
        array(
			'id'        => 'related_products_base',
			'type'      => 'select',
			'title'     => esc_html__( 'Related Products', 'studiare' ),
			'options'   => array(
				'product_cat' => esc_html__( 'Products from same category', 'studiare' ),
				'product_tag' => esc_html__( 'Products from same tag', 'studiare' ),
			),
			'default'   => 'product_cat',
			'select2'   => array('allowClear' => false)
		),
        array(
			'id'       => 'radio_instead_dropdown_variable_items',
			'type'     => 'switch',
			'title'    => esc_html__('radio instead of dropdown variable items', 'studiare'),
			'subtitle'    => esc_html__('Display radio list instead of dropdown for variable products.', 'studiare'),
			'default'  => true
		),
		array(
			'id'       => 'product_single_rating_mode',
			'type'     => 'switch',
			'title'    => esc_html__('Rating with emojis', 'studiare'),
			'subtitle'  => esc_html__( 'If this option is enabled, product ratings can be selected using emojis instead of a dropdown menu.', 'studiare' ),
			'default'  => false,
		),

        array(
			'id'       => 'studi_readmore_in_pro',
			'type'     => 'switch',
			'title'    => esc_html__('Show Read More In Mobile', 'studiare'),
			'default'  => false
		),
        array(
          'id'       => 'studi_readmore_in_desktops',
          'type'     => 'switch',
          'title'    => esc_html__('Show Read More In Desktop', 'studiare'),
          'default'  => 0, // default OFF
        ),		
		array(
			'id'       => 'readmore_open_txt',
			'type'     => 'text',
			'title'    => esc_html__('Read more button text in closed mode', 'studiare'),
			'default'  => esc_html__('Show More', 'studiare'),
		),
		array(
			'id'       => 'readmore_close_txt',
			'type'     => 'text',
			'title'    => esc_html__('Read more button text in open mode', 'studiare'),
			'default'  => esc_html__('Show Less', 'studiare'),
		),
        		// Collapsed Height - MOBILE
        array(
          'id'       => 'studi_readmore_height_mobile',
          'type'     => 'slider',
          'title'    => esc_html__('Collapsed Height (px) - Mobile', 'studiare'),
          'default'  => 260,
          'min'      => 120,
          'max'      => 1200,
          'step'     => 10,
          'required' => array('studi_readmore_in_pro', '=', '1'), // show only when mobile is ON
        ),
        
        // Collapsed Height - DESKTOP
        array(
          'id'       => 'studi_readmore_height_desktop',
          'type'     => 'slider',
          'title'    => esc_html__('Collapsed Height (px) - Desktop', 'studiare'),
          'default'  => 340,
          'min'      => 120,
          'max'      => 1200,
          'step'     => 10,
          'required' => array('studi_readmore_in_desktops', '=', '1'), // show only when desktop is ON
        ),
        // Sticky/Floating button
        array(
          'id'       => 'studi_readmore_sticky',
          'type'     => 'switch',
          'title'    => esc_html__('Keep Button Floating Until Section End', 'studiare'),
          'default'  => 1,
        ),
        
        // z-index
        array(
          'id'       => 'studi_readmore_zindex',
          'type'     => 'spinner',
          'title'    => esc_html__('Button z-index', 'studiare'),
          'default'  => 10,
          'min'      => 1,
          'max'      => 9999,
        ),
        
        // Target section selector
        array(
          'id'       => 'studi_readmore_target_selector',
          'type'     => 'text',
          'title'    => esc_html__('Target CSS Selector', 'studiare'),
          'desc'     => esc_html__('Collapsible selector (e.g. .studi_pro_content_holder)', 'studiare'),
          'default'  => '.studi_pro_content_holder',
        ),
        
        // Colors
        array(
          'id'       => 'studi_readmore_color_bg',
          'type'     => 'color',
          'title'    => esc_html__('Button Background', 'studiare'),
          'default'  => '#ffffff',
        ),
        array(
          'id'       => 'studi_readmore_color_text',
          'type'     => 'color',
          'title'    => esc_html__('Button Text Color', 'studiare'),
          'default'  => '#0049f8',
        ),
        array(
          'id'       => 'studi_readmore_color_border',
          'type'     => 'color',
          'title'    => esc_html__('Button Border Color', 'studiare'),
          'default'  => '#0049f8',
        ),
        array(
          'id'       => 'studi_readmore_color_fade_top',
          'type'     => 'color_rgba',
          'title'    => esc_html__('Fade Top Color', 'studiare'),
          'default'  => array('color' => '#ffffff', 'alpha' => 0),
        ),
        array(
          'id'       => 'studi_readmore_color_fade_bot',
          'type'     => 'color_rgba',
          'title'    => esc_html__('Fade Bottom Color', 'studiare'),
          'default'  => array('color' => '#ffffff', 'alpha' => 1),
        ),


		array(
			'id'       => 'related_products_count',
			'type'     => 'text',
			'title'    => esc_html__('Number of related products/courses', 'studiare'),
			'default'  => '4'
		),
		array(
			'id'       => 'related_products_per_slide',
			'type'     => 'text',
			'title'    => esc_html__('The number of related products/courses columns in the carousel', 'studiare'),
			'subtitle'    => esc_html__('For Product Layout 1', 'studiare'),
			'default'  => '2'
		),
		array(
			'id'       => 'related_products_per_slide_ltwo',
			'type'     => 'text',
			'title'    => esc_html__('The number of related products/courses columns in the carousel', 'studiare'),
			'subtitle'    => esc_html__('For Product Layout 2', 'studiare'),
			'default'  => '3'
		),
		array(
			'id'       => 'related_products_per_slide_lthree',
			'type'     => 'text',
			'title'    => esc_html__('The number of related products/courses columns in the carousel', 'studiare'),
			'subtitle'    => esc_html__('For Product Layout 3', 'studiare'),
			'default'  => '3'
		),
		array(
			'id'       => 'user_other_products_count',
			'type'     => 'text',
			'title'    => esc_html__('Number of Other Teacher Courses', 'studiare'),
			'default'  => '4'
		),
		array(
                'id'        => 'opt-accordion-end-4',
                'type'      => 'accordion',
                'position'  => 'end'
        ),
	)
) );
$general_off_img = "<img src='".get_parent_theme_file_uri('assets/images/admin/general_off.jpg')."'>";
Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'discount message', 'studiare' ),
	'id'               => 'product_single_sc_message_section',
	'subsection'       => true,
	'icon' => 'fal fa-gift',
	'fields' => array(
array(
			'id'       => 'product_single_sc_message',
			'type'     => 'switch',
			'title'    => esc_html__('Show discount message', 'studiare'),
			'subtitle'  => esc_html__( 'General discount message for all products', 'studiare' ),
			'default'  => false,
			'desc'     => $general_off_img,
		),
		array(
			'id'        => 'sc_offer_amount_in',
			'type'      => 'slider',
			'title'     => esc_html__('Amount of discount code', 'studiare'),
			'subtitle'  => esc_html__( 'If you have created a discount code or coupon in WooCommerce, enter the discount amount here', 'studiare' ),
			"default"   => 50,
			"min"       => 0,
			"step"      => 1,
			"max"       => 100,
			'display_value' => 'label',
			'required'  => array('product_single_sc_message', '=', '1'),
			//'tags'     => 'header size logo height logo size'
		),
		array(
			'id'        => 'product_single_sc_message_0',
			'type'      => 'editor',
			'title'     => esc_html__( 'Discount message text', 'studiare' ),
			'subtitle'  => esc_html__( 'Use the following shortcode to display the calculated price according to the above discount amount: [sc_amazing_offer_final_price]', 'studiare' ),
			'required'  => array('product_single_sc_message', '=', '1'),
			'default'   => esc_html__( 'Buy this product with %50 discount with suncode discount code. ie: [sc_amazing_offer_final_price]', 'studiare' ),
		),
		array(
			'id'       => 'sc--discount-bg',
			'type'     => 'background',
			'title'    => esc_html__( 'Discount message Background', 'studiare' ),
			'output'   => '.sc-single-product-message',
			'required'  => array('product_single_sc_message', '=', '1'),
			'default'  => array(
				'background-color' => '#ffc107',
			)
		),
		array(
			'id'       => 'sc--discount-txt',
			'type'     => 'color',
			'title'    => esc_html__( 'Discount message text color', 'studiare' ),
			'output'   => array('color' => '.sc-single-product-message'),//'.sc-single-product-message',
			'required'  => array('product_single_sc_message', '=', '1'),
			'default'  => '#fff',
			'validate' => 'color',
		),
		)
) );
$img_hint = "<img src='".get_parent_theme_file_uri('assets/images/admin/general_atts.jpg')."'>";
Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'General features', 'studiare' ),
	'id'               => 'sc_view_page_general_section',
	'subsection'       => true,
	'icon' => 'fal fa-digital-tachograph',
	'fields' => array(
	    array(
	        
			'id'       => 'sc_view_page_general_att_top',
			'type' => 'raw',
			'title'    => esc_html__('Show General features', 'studiare'),
			'subtitle' => $img_hint,
		),
        array(
			'id'       => 'sc_view_page_general_att',
			'type'     => 'switch',
			'title'    => esc_html__('Show General features', 'studiare'),
			'subtitle' => esc_html__( 'Display general features at the bottom of the product image', 'studiare' ),
			'default'  => false
		),
		array(
        'id'       => 'sc_select_page_general_att',
        'type'     => 'select',
        'multi'    => false,
        'data'     => 'posts',
        'args'     => array( 'post_type' =>  array( 'page' ), 'numberposts' => -1 ),
        'title'    => esc_html__( 'General Features Page', 'studiare' ),
        'subtitle' => esc_html__( 'The content of the selected Pageis displayed at the bottom of each product image.', 'studiare' ),
				'required'  => array('sc_view_page_general_att', '=', '1'),
    ),
	array(
        'id'       => 'sc_select_page_general_att_exclude_cats',
        'type'     => 'select',
        'multi'    => true,
         'data' => 'terms',
            'args' => array('taxonomies'=>'product_cat', 'args'=>array()),
        'title'    => esc_html__( 'Exclude categories', 'studiare' ),
        'subtitle' => esc_html__( 'The content of the selected pageis not displayed at the bottom of each product image in these categories.', 'studiare' ),
				'required'  => array('sc_view_page_general_att', '=', '1'),
    ),
	)
) );
//add by suncode end

Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Share', 'studiare' ),
	'id'               => 'course_sharing_settings',
	'subsection'       => true,
	'icon' => 'fal fa-share-alt-square',
	'fields'           => array(
		array(
			'id'       => 'course_share_story',
			'title'    => esc_html__( 'Share Product', 'studiare' ),
			'type'     => 'switch',
			'default'  => true,
			'on'       => esc_html__( 'Enable', 'studiare' ),
			'off'      => esc_html__( 'Disable', 'studiare' )
		),
		//array(
		//	'id'       => 'course_share_story_networks',
		//	'title'    => esc_html__( 'اشتراک گذاری:', 'studiare' ),
		//	'subtitle' => esc_html__( 'برای فعال کردن یا غیرفعال کردن به داخل باکس مورد نظر بکشید و رها کنید.', 'studiare' ),
		//	'type'     => 'sorter',
		//	'options'  => $share_story_networks,
		//	'required' => array('course_share_story', '=', '1')
		//),
		//array(
		//	'id'       => 'course_share_text',
		//	'type'     => 'editor',
		//	'title'    => esc_html__( 'متن اشتراک گذاری', 'studiare' ),
		//	'subtitle' => esc_html__( 'قبل از آیکن ها قرار می گیرد.', 'studiare' ),
		//	'required' => array('course_share_story', '=', '1')
		//),
		array(
			'id'       => 'sc_site_email',
			'type'     => 'text',
			'title'    => esc_html__('Website e-Mail', 'studiare'),
			'subtitle'    => esc_html__('Only email with site domain should be placed in this section. Emails from Yahoo, Google, etc. will not work.', 'studiare'),
			'default'  => ''
		),
	)
) );

Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Checkout', 'studiare' ),
	'id'               => 'course_checkout_settings',
	'subsection'       => true,
	'icon' => 'fal fa-money-check',
	'fields'           => array(
		array(
			'id'       => 'course_checkout_address_fields',
			'title'    => esc_html__( 'Enable Address Fields Based on Product Type', 'studiare' ),
			'subtitle' => esc_html__( 'Enable or disable address fields in the checkout form dynamically based on the product type in the cart. Address fields will be removed for virtual/downloadable products.', 'studiare' ),
			'type'     => 'switch',
			'default'  => false,
			'on'       => esc_html__( 'Enable', 'studiare' ),
			'off'      => esc_html__( 'Disable', 'studiare' )
		),
	)
) );
