<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Studiare
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */
require_once get_template_directory() . '/inc/tgm/class-tgm-plugin-activation.php';

//add_action( 'tgmpa_register', 'studiare_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
add_action('tgmpa_register', 'studiare_register_plugins');
function studiare_register_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$api = 'https://studiaretheme.ir/api/';
	$plugins = array(
	    array(
			'name'      => esc_html__( 'Redux Framework', 'studiare' ),
			'slug'      => 'redux-framework',
			'required'  => true,
		),
	    array(
			'name'      => esc_html__( 'Studiare Core', 'studiare' ),
			'slug'      => 'studiare-core',
			'source'    => $api . 'studiare-core.zip',
			'required'  => true,
			'version'   => '13.2',
			'force_activation'   => true,
		),
		array(
			'name'      => esc_html__( 'Elementor', 'studiare' ),
			'slug'      => 'elementor',
			'required'  => true,
		),
		array(
			'name'      => esc_html__( 'Elementor Pro', 'studiare' ),
			'slug'      => 'elementor-pro',
			'required'  => true,
			'version'   => '3.31.2',
			'external_url' => $api . 'elementor-pro.zip',
			'source'    => $api . 'elementor-pro.zip',
		),
		array(
			'name'               => esc_html__( 'WooCommerce', 'studiare' ),
			'slug'               => 'woocommerce',
			'required'           => true,
		),
		array(
			'name'               => esc_html__( 'Persian Woocommerce', 'studiare' ),
			'slug'               => 'persian-woocommerce',
			'required'           => true,
		),

		array(
			'name'      => esc_html__( 'Slider Revolution', 'studiare' ),
			'slug'      => 'revslider',
			'source'    => $api . 'revslider.zip',
			'external_url' => $api . 'revslider.zip',
			'required'  => false,
			'version'   => '6.7.37',
		),


		array(
			'name'      => esc_html__( 'Events Manager', 'studiare' ),
			'slug'      => 'wp-events-manager',
			'required'  => false,
		),
		
	array(
			'name'      => esc_html__( 'MailChimp for WordPress', 'studiare' ),
			'slug'      => 'mailchimp-for-wp',
		'required'  => false,
		),

		
		array(
			'name'        => esc_html__( 'FiboSearch', 'studiare' ),
			'slug'        => 'ajax-search-for-woocommerce',
			'required'    => false,
		),
		
		array(
			'name'        => esc_html__( 'Smart Wishlist', 'studiare' ),
			'slug'        => 'woo-smart-wishlist',
			'required'    => false,
		),
		

	);

	$config = array(
		'default_path'    => '',
		'menu'            => 'tgmpa-install-plugins',
		'has_notices'     => true,
		'dismissable'     => true,
		'dismiss_msg'     => '',
		'is_automatic'    => true,
		'message'         => '',
	);

	tgmpa( $plugins, $config );
}




add_action('admin_init', 'check_studiare_core_version');
function check_studiare_core_version() {
    if (!is_admin()) {
        return;
    }

    $plugin_path = WP_PLUGIN_DIR . '/studiare-core/studiare-core.php';
    $required_version = '13.2';

    if (file_exists($plugin_path)) {
        $plugin_data = get_plugin_data($plugin_path);
        $current_version = $plugin_data['Version'];

        if (version_compare($current_version, $required_version, '<')) {
            global $pagenow;
            if ($pagenow !== 'plugins.php' && $pagenow !== 'update.php' && $pagenow !== 'admin.php' && $pagenow !== 'plugin-install.php') {
                wp_redirect(admin_url('admin.php?page=tgmpa-install-plugins&plugin_status=update'));
                exit;
            }

            add_action('admin_notices', function () use ($current_version, $required_version) {
                ?>
               <div dir="auto" style="--error-bg: linear-gradient(to bottom, #FFF5F5 0%, rgba(255,245,245,0.8) 100%); --error-text: #7F1D1D; --error-border: #DC2626; --error-accent: #B91C1C; --error-gradient: linear-gradient(to bottom, rgba(220,38,38,0.2) 0%, rgba(220,38,38,0) 100%); background: var(--error-gradient), var(--error-bg); padding: 1.5rem; border-radius: 0.75rem; color: var(--error-text); border-inline-start: 0.25rem solid var(--error-border); display: flex; gap: 1rem; align-items: flex-start; margin: 20px auto; max-width: 100%; position: relative; overflow: hidden; ">
    <div style=" position: absolute; inset-inline-end: 1rem; top: 50%; transform: translateY(-50%); opacity: 0.1; z-index: 0; ">
        <svg width="120" height="120" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 8V12M12 16H12.01M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z" stroke="var(--error-border)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
    </div>
    
   
    <div style="position: relative; z-index: 1; flex: 1;">
        <p style="font-size: 1rem; line-height: 1.5; margin: 0 0 0.75rem 0; font-weight: 500;">
            <?php
            printf(
                esc_html__('Please update the Studiare Core plugin to version %s. Your current version is %s. Access to the dashboard is restricted until updated.', 'studiare'),
                '<span style="font-weight: 600; color: var(--error-accent);">' . esc_html($required_version) . '</span>',
                '<span style="font-weight: 600; color: var(--error-accent);">' . esc_html($current_version) . '</span>'
            );
            ?>
        </p>
        <a href="<?php echo admin_url('admin.php?page=tgmpa-install-plugins&plugin_status=update'); ?>" style="
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            background: var(--error-border);
            color: white;
            text-decoration: none;
            border-radius: 0.375rem;
            font-weight: 500;
            font-size: 0.875rem;
            transition: all 0.2s ease;
            position: relative;
            overflow: hidden;
            z-index: 1;
        ">
            <?php esc_html_e('Go to plugin updates', 'studiare'); ?>
            <svg style="margin-inline-start: 0.5rem; transform: rotate(<?php echo is_rtl() ? '180deg' : '0deg'; ?>);" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </a>
    </div>
</div>
                <?php
            });
        }
    } else {
        add_action('admin_notices', function () {
            ?>
                <div class="notice notice-error" style="background: #ffa1a1; padding: 50px 10px; border-radius: 18px; color: red; font-weight: 700;">
                <p>
                    <?php esc_html_e('The Studiare Core plugin is not installed. Please install and activate it.', 'studiare'); ?>
                    <a href="<?php echo admin_url('admin.php?page=tgmpa-install-plugins&plugin_status=update'); ?>">
                        <?php esc_html_e('Go to plugin updates', 'studiare'); ?>
                    </a>
                </p>
            </div>
            <?php
        });
    }
}

add_action('admin_notices', 'add_studiare_plugins_notice');
function add_studiare_plugins_notice() {
    global $pagenow;
    if ($pagenow === 'admin.php' && isset($_GET['page']) && $_GET['page'] === 'tgmpa-install-plugins') {
        ?>
        <div class="wrap o-notice gray">
            <div class="holder">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle" viewBox="0 0 16 16">
                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 0 0 8 0a8 8 0 0 0 0 16z"></path>
                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533L8.93 6.588zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0z"></path>
                </svg>
                <?php _e('List of Useful Plugins for Studiare Theme', 'studiare'); ?>
            </div>
            <a href="https://docs.studiaretheme.ir/tuts/setting-up/required-plugins/" target="_blank" class="btn">
                <?php _e('More Information', 'studiare'); ?>
            </a>
            <style>
            .o-notice { margin-top: 20px; -webkit-box-shadow: none; box-shadow: none; border: none; -webkit-box-sizing: border-box; box-sizing: border-box; padding: 14px 1rem; display: -webkit-box; display: -webkit-flex; display: -ms-flexbox; display: flex ; -webkit-box-align: center; -webkit-align-items: center; -ms-flex-align: center; align-items: center; -webkit-box-pack: justify; -webkit-justify-content: space-between; -ms-flex-pack: justify; justify-content: space-between; color: #3D84FC ; border-left: 5px solid #3D84FC; background-color: #d9e7fe; min-height: 50px; font-size: 15px; line-height: 1.5; border-radius: 0.35rem; }
                   .o-notice.gray a.btn { padding: 0px 0.55rem; font-size: 14px; background-color: #3D84FC; border: 1px solid #3D84FC; color: #fff; min-height: 30px; line-height: 1; display: -webkit-inline-box; display: -webkit-inline-flex; display: -ms-inline-flexbox; display: inline-flex ; -webkit-transition-duration: .2s; -o-transition-duration: .2s; transition-duration: .2s; -webkit-box-shadow: none; box-shadow: none; cursor: pointer; text-decoration: none; font-weight: 500; -webkit-box-sizing: border-box; box-sizing: border-box; -webkit-box-align: center; -ms-flex-align: center; -webkit-align-items: center; align-items: center; border-radius: 0.25rem; -webkit-transition: allcubic-bezier(0.645, 0.045, 0.355, 1) 0.35s; -o-transition: all cubic-bezier(0.645, 0.045, 0.355, 1) 0.35s; transition: allcubic-bezier(0.645, 0.045, 0.355, 1) 0.35s; }

            </style>
        </div>
        <?php
    }
}