<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class Group_Control_Darkmode_Background extends Group_Control_Base {

    protected static $fields;

    public static function get_type() {
        return 'darkmode-background';
    }

    protected function init_fields() {
        $fields = [];

        $fields['darkmode_bg_type'] = [
            'label' => esc_html__( 'Dark Mode Background', 'studiare' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'none' => esc_html__( 'No Change', 'studiare' ),
                'primary' => esc_html__( 'Dark Color Primary', 'studiare' ),
                'secondary' => esc_html__( 'Dark Color Secondary', 'studiare' ),
                'custom' => esc_html__( 'Custom', 'studiare' ),
            ],
            'default' => 'none',
            'selectors' => [
                'body.scdarkcolors {{WRAPPER}}.darkmode-bg-primary' => 'background: var(--dark_primary_color);',
                'body.scdarkcolors {{WRAPPER}}.darkmode-bg-secondary' => 'background: var(--dark_secondary_color);',
            ],
            'prefix_class' => 'darkmode-bg-',
        ];

        $fields['darkmode_bg_custom'] = [
            'label' => esc_html__( 'Custom Background', 'studiare' ),
            'type' => Controls_Manager::COLOR,
            'condition' => [
                'darkmode_bg_type' => 'custom',
            ],
            'selectors' => [
                'body.scdarkcolors {{WRAPPER}}' => 'background: {{VALUE}};',
            ],
        ];

        return $fields;
    }
}