<?php

namespace Maxcoach_Elementor;

use Elementor\Group_Control_Base;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) || exit;

/**
 * Elementor tooltip control.
 *
 * A base control for creating tooltip control.
 *
 * @since 1.0.0
 */
class Group_Control_Tooltip extends Group_Control_Base {

	protected static $fields;

	public static function get_type() {
		return 'tooltip';
	}

	protected function init_fields() {
		$fields = [];

		$fields['skin'] = [
			'label'   => esc_html__( 'Tooltip Skin', 'studiare' ),
			'type'    => Controls_Manager::SELECT,
			'options' => [
				''        => esc_html__( 'Black', 'studiare' ),
				'white'   => esc_html__( 'White', 'studiare' ),
				'primary' => esc_html__( 'Primary', 'studiare' ),
			],
			'default' => '',
		];

		$fields['position'] = [
			'label'   => esc_html__( 'Tooltip Position', 'studiare' ),
			'type'    => Controls_Manager::SELECT,
			'options' => [
				'top'          => esc_html__( 'Top', 'studiare' ),
				'right'        => esc_html__( 'Right', 'studiare' ),
				'bottom'       => esc_html__( 'Bottom', 'studiare' ),
				'left'         => esc_html__( 'Left', 'studiare' ),
				'top-left'     => esc_html__( 'Top Left', 'studiare' ),
				'top-right'    => esc_html__( 'Top Right', 'studiare' ),
				'bottom-left'  => esc_html__( 'Bottom Left', 'studiare' ),
				'bottom-right' => esc_html__( 'Bottom Right', 'studiare' ),
			],
			'default' => 'top',
		];

		return $fields;
	}

	protected function get_default_options() {
		return [
			'popover' => [
				'starter_title' => _x( 'Tooltip', 'Tooltip Control', 'studiare' ),
				'starter_name'  => 'enable',
				'starter_value' => 'yes',
				'settings'      => [
					'render_type' => 'template',
				],
			],
		];
	}
}
