<?php
// Function to render the dark mode toggle button
function studiare_render_dark_mode_button($echo = true) {
    if (!function_exists('codebean_option')) {
        return '';
    }

    // Check if dark mode is enabled and the button should be shown in the header
    $show_darkmode_icon = codebean_option('show_darkmode_icon_in_header') ?? false;
    $dark_mode_ready = codebean_option('sc_darkmode_ready') ?? false;

    if (!$dark_mode_ready || !$show_darkmode_icon) {
        return '';
    }

    // Build the HTML output
    ob_start();
    ?>
    <div class="top-bar-darkmode">
            <a href="#" class="dark-mode-toggle">
                <span class="darkmode-icon">
                    <span class="dark-mode-icon-light" style="display: block;">
                                                    <i aria-hidden="true" class="fal fa-sun"></i>                                            </span>
                    <span class="dark-mode-icon-dark" style="display: none;">
                                                    <i aria-hidden="true" class="fal fa-moon"></i>                                            </span>
                </span>
            </a>
    </div>
    <?php
    $output = ob_get_clean();

    if ($echo) {
        echo $output;
    }

    return $output;
}