<?php
/**
 * Checkout login form - Customized for OTP support
 *
 * @package WooCommerce\Templates
 * @version 10.0.0
 */

defined( 'ABSPATH' ) || exit;

$registration_at_checkout   = WC_Checkout::instance()->is_registration_enabled();
$login_reminder_at_checkout = 'yes' === get_option( 'woocommerce_enable_checkout_login_reminder' );

if ( is_user_logged_in() ) {
	return;
}

// Check if OTP feature is enabled via theme options
$otp_situ = '0';
if ( class_exists( 'Redux' ) ) {
	$otp_situ = codebean_option( 'otp' );
}

// Display login reminder message
if ( $login_reminder_at_checkout ) : ?>
	<div class="woocommerce-form-login-toggle">
		<?php
		$link_class = ( $otp_situ === '1' ) ? 'studi_showlogin' : 'showlogin';

		wc_print_notice(
			apply_filters( 'woocommerce_checkout_login_message', esc_html__( 'Returning customer?', 'woocommerce' ) ) .
			' <a href="#" class="' . esc_attr( $link_class ) . '">' . esc_html__( 'Click here to login', 'woocommerce' ) . '</a>',
			'notice'
		);
		?>
	</div>
<?php endif; ?>

<?php
if ( $registration_at_checkout || $login_reminder_at_checkout ) :

	// Always show login form after a failed login attempt
	$show_form = isset( $_POST['login'] ); // phpcs:ignore WordPress.Security.NonceVerification.Missing

	// Only display the login form if OTP is disabled
	if ( $otp_situ !== '1' ) {
		woocommerce_login_form(
			array(
				'message'  => esc_html__( 'If you have shopped with us before, please enter your details below. If you are a new customer, please proceed to the Billing section.', 'woocommerce' ),
				'redirect' => wc_get_checkout_url(),
				'hidden'   => ! $show_form,
			)
		);
	}
endif;

// Inject custom JS if OTP is enabled
if ( $otp_situ === '1' ) : ?>
	<script>
		jQuery(document).ready(function($){
			$('.studi_showlogin').on('click', function(e){
				e.preventDefault();
				if ( $('.register-modal-opener').length > 0 ) {
					$('.register-modal-opener').trigger('click');
				}
			});
		});
	</script>
<?php endif; ?>
