<?php
/**
 * Single Product Layout 02
 * Optimized for performance, readability, and WordPress/WooCommerce standards
 */

defined('ABSPATH') || exit;

// Retrieve Redux settings efficiently
$course_post_share = class_exists('Redux') ? codebean_option('course_share_story') : false;
$course_share_text = class_exists('Redux') ? codebean_option('course_share_text') : '';
$product_meta_info_list = class_exists('Redux') ? codebean_option('product_meta_info_list') : false;
$product_buyers_insingle = class_exists('Redux') ? codebean_option('product_buyers_insingle') : false;
$product_meta_info_list_short_link = class_exists('Redux') ? codebean_option('product_meta_info_list_short_link') : false;
$product_meta_info_list_cats = class_exists('Redux') ? codebean_option('product_meta_info_list_cats') : false;
$product_meta_info_list_stars = class_exists('Redux') ? codebean_option('product_meta_info_list_stars') : false;
$product_meta_info_list_date_published = class_exists('Redux') ? codebean_option('product_meta_info_list_date_published') : false;
$product_meta_info_list_date_modified = class_exists('Redux') ? codebean_option('product_meta_info_list_date_modified') : false;
$product_meta_info_list_tags = class_exists('Redux') ? codebean_option('product_meta_info_list_tags') : false;
$product_sidebar_position = class_exists('Redux') ? codebean_option('product_sidebar_position') : 0;
$tickets_status = class_exists('Redux') ? codebean_option('tickets_status') : false;
$product_single_sc_show_buyers = class_exists('Redux') ? codebean_option('product_single_sc_show_buyers') : '0';

// Define meta keys with defaults
$prefix = '_studiare_';
$meta_keys = [
    '_stock' => '',
    $prefix . 'course_duration' => '',
    $prefix . 'course_lesseons' => '',
    $prefix . 'course_level' => '',
    $prefix . 'sc_file_type' => '',
    $prefix . 'sc_file_size' => '',
    $prefix . 'sc_file_type_icon' => '',
    $prefix . 'course_certificate' => '',
    $prefix . 'course_language' => '',
    $prefix . 'course_sessions' => '',
    $prefix . 'sc_course_type_selector' => '',
    $prefix . 'course_buyers_text' => 'دانشجو',
    $prefix . 'course_buyers_text_hint' => 'تعداد دانشجویان',
    $prefix . 'course_buyers_text_icon' => 'fal fa-users',
    $prefix . 'course_duration_hint' => 'مدت زمان آموزش',
    $prefix . 'course_lesseons_hint' => 'تعداد سرفصل ها',
    $prefix . 'course_level_hint' => 'سطح آموزش',
    $prefix . 'sc_file_type_hint' => 'نوع فایل',
    $prefix . 'sc_file_size_hint' => 'حجم فایل',
    $prefix . 'course_certificate_hint' => 'نوع گواهی',
    $prefix . 'course_language_hint' => 'زبان آموزش',
    $prefix . 'course_sessions_hint' => 'تعداد جلسات',
    $prefix . 'sc_course_type_title_1' => '',
    $prefix . 'sc_course_type_title_2' => '',
    $prefix . 'metaboxjff_sections' => '',
    $prefix . 'course_teachers' => '',
    '_studiare_woo_course_date_update' => '',
    'total_sales' => 0,
];

// Fetch all meta values in one go
$meta_values = [];
$post_id = get_the_ID();
foreach ($meta_keys as $key => $default) {
    $meta_values[$key] = get_post_meta($post_id, $key, true) ?: $default;
}

// Determine sidebar position class
$position_of_single_sidebar = ($product_sidebar_position == 1) ? 'screversed' : '';

// Helper function to display meta units
function display_meta_unit_box($icon, $label, $value, $hint) {
    if (!empty($value)) {
        if (strpos($icon, 'fal') === 0) {
            $icon = substr($icon, 0, 3) . ' ' . substr($icon, 3);
        } else {
            $icon = $icon;
        }
        ?>
        <div class="col-md-2 col-xs-6">
            <div class="meta-info-unit-box hint--top" aria-label="<?php echo esc_attr($hint); ?>">
                <div class="icon"><i class="<?php echo esc_attr($icon); ?>"></i></div>
                <div class="value"><?php echo esc_html($value); ?></div>
            </div>
        </div>
        <?php
    }
}
?>

<div id="product-<?php the_ID(); ?>" <?php post_class("studi_single_pro_" . $product_layout); ?>>
    <div class="container <?php echo esc_attr($position_of_single_sidebar); ?>">
        <?php include_once "sc_pro_offer_box.php"; ?>
        <!-- Product Top Part -->
        <div class="single_pro_top row">
            <div class="col-md-5 col-xs-12">
                <div class="studi_simple_box studi_price_box">
                    <?php do_action('woocommerce_single_product_summary'); ?>
                </div>
                <div class="row studi_share_view">
                    <div class="col-md-6 col-xs-12">
                        <?php if ($course_post_share): ?>
                            <div class="sc_studi_share_box studi_simple_box">
                                <span>اشتراک گذاری :</span><?php echo do_shortcode('[sc_studiare_product_share_box]'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if (class_exists('Redux') && codebean_option('product_meta_info_comment_number')): ?>
                    <div class="col-md-6 col-xs-12">
                        <div class="sccommentnumber studi_simple_box">
                            <a href="javascript:void(0);" onclick="jQuery('html, body').animate({scrollTop: jQuery('#reviews').offset().top}, 2000);">
                                <span class="icon"><i class="fal fa-comments-alt"></i></span><?php echo get_comments_number(); ?> <?php esc_html_e('Comment', 'studiare'); ?>
                            </a>
                            <span class="sc_studi_number_of_views"><i class="fal fa-eye"></i><?php echo sc_studi_gt_get_post_view(); ?></span>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php if ($product_meta_info_list_short_link): ?>
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <div class="studi_shortlink studi_simple_box">
                                <span class="icon"><i class="fal fa-link"></i></span>
                                <span class="info"><?php esc_html_e('Short Link :', 'studiare'); ?></span>
                                <span class="scshort-link"><?php echo esc_url(wp_get_shortlink()); ?>
                                    <span class="sc_autocopy hint--top" aria-label="<?php esc_attr_e('Copy Link', 'studiare'); ?>"
                                          onclick="sc_auto_copy_text('<?php echo esc_js(wp_get_shortlink()); ?>', '<?php esc_js(_e('Copy Link', 'studiare')); ?>', '<?php esc_js(_e('Copied', 'studiare')); ?>')">
                                        <i class="fal fa-clone"></i>
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <!-- Product Gallery -->
            <div class="col-md-7 col-xs-12 pro_gallery_holder">
                <div class="course-single-gallery">
                    <?php do_action('woocommerce_before_single_product_summary'); ?>
                </div>
            </div>
            <div class="container">
                <?php include_once "sc_post_excerpt.php"; ?>
            </div>
        </div>
        <div class="single_middle_info row">
            <?php if ($product_meta_info_list): ?>
                <div class="product-meta-info-holders col-md-12 col-xs-12">
                    <?php if ($product_buyers_insingle): ?>
                    <?php 
                    $icon = $meta_values[$prefix . 'course_buyers_text_icon'];
                    if (strpos($icon, 'fal') === 0) {
                        $icon_class = substr($icon, 0, 3) . ' ' . substr($icon, 3);
                    } else {
                        $icon_class = $icon;
                    }
                    ?>
                        <div class="col-md-2 col-xs-6">
                            <div class="meta-info-unit-box hint--top" aria-label="<?php echo esc_attr($meta_values[$prefix . 'course_buyers_text_hint']); ?>">
                                <div class="icon"><i class="<?php echo esc_attr($icon_class); ?>"></i></div>
                                <div class="value"><?php $count = $meta_values['total_sales']; $text = sprintf(_n("%s %s", "%s %s", $count, 'studiare'), number_format_i18n($count), $meta_values[$prefix . 'course_buyers_text']); echo esc_html($text); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php
                    // Define meta info array for display
                    $meta_info = [
                        ['icon' => 'fal fa-language', 'hint' => $meta_values[$prefix . 'course_language_hint'], 'value' => $meta_values[$prefix . 'course_language']],
                        ['icon' => 'fal fa-clock', 'hint' => $meta_values[$prefix . 'course_duration_hint'], 'value' => $meta_values[$prefix . 'course_duration']],
                        ['icon' => 'fal fa-list-alt', 'hint' => $meta_values[$prefix . 'course_lesseons_hint'], 'value' => $meta_values[$prefix . 'course_lesseons']],
                        ['icon' => 'fal fa-list', 'hint' => $meta_values[$prefix . 'course_sessions_hint'], 'value' => $meta_values[$prefix . 'course_sessions']],
                        ['icon' => 'fal fa-signal-4', 'hint' => $meta_values[$prefix . 'course_level_hint'], 'value' => $meta_values[$prefix . 'course_level']],
                        ['icon' => $meta_values[$prefix . 'sc_file_type_icon'], 'hint' => $meta_values[$prefix . 'sc_file_type_hint'], 'value' => $meta_values[$prefix . 'sc_file_type']],
                        ['icon' => 'fal fa-save', 'hint' => $meta_values[$prefix . 'sc_file_size_hint'], 'value' => $meta_values[$prefix . 'sc_file_size']],
                        ['icon' => 'fal fa-award', 'hint' => $meta_values[$prefix . 'course_certificate_hint'], 'value' => $meta_values[$prefix . 'course_certificate']],
                    ];

                    // Display course type conditionally
                    if ($meta_values[$prefix . 'sc_course_type_selector'] == 1) {
                        display_meta_unit_box('fal fa-signal', esc_html__('Course Type', 'studiare'), $meta_values[$prefix . 'sc_course_type_title_1'], esc_html__('Course Type', 'studiare'));
                    } elseif ($meta_values[$prefix . 'sc_course_type_selector'] == 2) {
                        display_meta_unit_box('fal fa-signal-slash', esc_html__('Course Type', 'studiare'), $meta_values[$prefix . 'sc_course_type_title_2'], esc_html__('Course Type', 'studiare'));
                    }

                    // Loop through meta info
                    foreach ($meta_info as $info) {
                        display_meta_unit_box($info['icon'], $info['hint'], $info['value'], $info['hint']);
                    }

                    // Custom entries
                    $custom_entries = $meta_values[$prefix . 'metaboxjff_sections'];
                    if ($custom_entries) {
                        foreach ((array)$custom_entries as $entry) {
                            $title = isset($entry[$prefix . 'sc_studi_custom_title_1']) ? esc_html($entry[$prefix . 'sc_studi_custom_title_1']) : '';
                            $content = isset($entry[$prefix . 'sc_studi_custom_text_1']) ? esc_html($entry[$prefix . 'sc_studi_custom_text_1']) : '';
                            $icon = isset($entry[$prefix . 'sc_studi_custom_icon_1']) ? substr($entry[$prefix . 'sc_studi_custom_icon_1'], 0, 3) . ' ' . substr($entry[$prefix . 'sc_studi_custom_icon_1'], 3) : 'fal fa-list';
                            display_meta_unit_box($icon, $content, $title, $content);
                        }
                    }
                    ?>
                </div>
            <?php endif; ?>

            <!-- Middle Box Bottom Start -->
            <div class="studi_public_pro_data_bottom col-md-12 col-xs-12">
                <?php if ($product_meta_info_list_cats): ?>
                    <?php $product_cats = get_the_terms($post_id, 'product_cat'); ?>
                    <?php if ($product_cats): ?>
                        <div class="col-md-4 col-xs-12">
                            <div class="studi_simple_box pro_cat_holder">
                                <span class="icon"><i class="fal fa-folder-open"></i></span>
                                <span class="info">
                                    <span class="label"><?php esc_html_e('Category', 'studiare'); ?></span>
                                    <span class="value">
                                        <?php foreach ($product_cats as $cat): ?>
                                            <a href="<?php echo esc_url(get_term_link($cat)); ?>"><?php echo esc_html($cat->name); ?><span></span></a>
                                        <?php endforeach; ?>
                                    </span>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if ($product_meta_info_list_stars): ?>
                    <div class="col-md-2 col-xs-12">
                        <div class="studi_simple_box proRating_holder">
                            <?php if (!codebean_option('product_stars')): ?>
                                <span class="icon"><i class="fal fa-star"></i></span>
                            <?php endif; ?>
                            <span class="info"><?php woocommerce_template_loop_rating(); ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($product_meta_info_list_date_published): ?>
                    <div class="col-md-3 col-xs-12">
                        <div class="studi_simple_box">
                            <i class="fal fa-calendar-alt"></i> <span class="date_published"><?php esc_html_e('Published on', 'studiare'); ?>: <?php echo get_the_date(); ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($product_meta_info_list_date_modified && !empty($meta_values['_studiare_woo_course_date_update'])): ?>
                    <div class="col-md-3 col-xs-12">
                        <div class="studi_simple_box">
                            <i class="fal fa-calendar-edit"></i> <span class="date_published"><?php esc_html_e('Updated on', 'studiare'); ?>: <?php echo date_i18n("j F Y", $meta_values['_studiare_woo_course_date_update']); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <!-- Middle Box Bottom End -->
        </div>
        <div class="row">
            <div class="col-xs-12">
                <?php include_once "sc_public_items.php"; ?>
                <?php include_once "studi_content.php"; ?>

                <!-- Tags -->
                <?php if ($product_meta_info_list_tags): ?>
                    <?php $product_tags = get_the_terms($post_id, 'product_tag'); ?>
                    <?php if ($product_tags): ?>
                        <div class="studi_boot_pad_remover col-xs-12 mb20 protags_holder">
                            <div class="studi_simple_box">
                                <span class="icon"><i class="fal fa-tags"></i></span>
                                <span class="info">
                                    <span class="label"><?php esc_html_e('Tags', 'studiare'); ?></span>
                                    <span class="value">
                                        <?php foreach ($product_tags as $tag): ?>
                                            <a href="<?php echo esc_url(get_term_link($tag)); ?>"><?php echo esc_html($tag->name); ?><span></span></a>
                                        <?php endforeach; ?>
                                    </span>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <?php
                $product_meta_info_teacher_profile = codebean_option('product_meta_info_teacher_profile');
                if($product_meta_info_teacher_profile==1){?>
                <!-- teacher start -->
                        
                <?php
                $prefix = '_studiare_';
                $teachers = get_post_meta(get_the_ID(), $prefix . 'course_teachers', true);
                
                if (empty($teachers) || !is_array($teachers)) {
                    $teachers = array_filter([
                        $teacher_id ?? '',
                        $teacher_id_2 ?? '',
                        $teacher_id_3 ?? '',
                        $teacher_id_4 ?? ''
                    ], function($id) {
                        return !empty($id) && $id !== 'no-teacher';
                    });
                }
                
                if (!empty($teachers)) {
                    sc_adding_teachers_to_layout($teachers);
                }
                }
                ?>

                <?php sc_related_courses(); ?>
                <?php include_once "sc_comments.php"; ?>

                <!-- Support Tab -->
                <?php if ($tickets_status && class_exists('SWSS_ProductPageTab')): ?>
                    <div id="supporttab" class="tabcontent">
                        <?php
                        $SWSS_ProductPageTab = new SWSS_ProductPageTab();
                        $SWSS_ProductPageTab->render_ticket_product_tab();
                        ?>
                    </div>
                <?php endif; ?>

                <!-- Buyers List -->
                <?php if ($product_single_sc_show_buyers != '0' && current_user_can('administrator')): ?>
                    <div class="sc_pro_buyers_list">
                        <h2><?php esc_html_e('Buyers List', 'studiare'); ?></h2>
                        <?php sc_pro_buyers_list_render(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div> 